/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.sfjp.mikutoga.bin.export.BinaryExporter;
import jp.sfjp.mikutoga.math.MkPos3D;
import jp.sfjp.mikutoga.vmd.model.BezierParam;
import jp.sfjp.mikutoga.vmd.model.CameraMotion;
import jp.sfjp.mikutoga.vmd.model.CameraRotation;
import jp.sfjp.mikutoga.vmd.model.PosCurve;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;

class CameraExporter
extends BinaryExporter {
    CameraExporter(OutputStream stream) {
        super(stream);
    }

    void dumpCameraMotion(VmdMotion motion) throws IOException {
        List<CameraMotion> list = motion.getCameraMotionList();
        int count = list.size();
        this.dumpLeInt(count);
        for (CameraMotion cameraMotion : list) {
            int frame = cameraMotion.getFrameNumber();
            this.dumpLeInt(frame);
            float range = (float)cameraMotion.getRange();
            this.dumpLeFloat(range);
            MkPos3D targetPos = cameraMotion.getCameraTarget();
            this.dumpLeFloat((float)targetPos.getXpos());
            this.dumpLeFloat((float)targetPos.getYpos());
            this.dumpLeFloat((float)targetPos.getZpos());
            CameraRotation rotation = cameraMotion.getCameraRotation();
            this.dumpLeFloat((float)rotation.getLatitude());
            this.dumpLeFloat((float)rotation.getLongitude());
            this.dumpLeFloat((float)rotation.getRoll());
            this.dumpCameraCurve(cameraMotion);
            this.dumpLeInt(cameraMotion.getProjectionAngle());
            byte perspectiveSwitch = cameraMotion.hasPerspective() ? (byte)0 : 1;
            this.dumpByte(perspectiveSwitch);
        }
    }

    private void dumpCameraCurve(CameraMotion cameraMotion) throws IOException {
        PosCurve posCurve = cameraMotion.getTargetPosCurve();
        BezierParam xCurve = posCurve.getIntpltXpos();
        BezierParam yCurve = posCurve.getIntpltYpos();
        BezierParam zCurve = posCurve.getIntpltZpos();
        this.dumpCameraBezier(xCurve);
        this.dumpCameraBezier(yCurve);
        this.dumpCameraBezier(zCurve);
        BezierParam rotCurve = cameraMotion.getIntpltRotation();
        BezierParam rangeCurve = cameraMotion.getIntpltRange();
        BezierParam projCurve = cameraMotion.getIntpltProjection();
        this.dumpCameraBezier(rotCurve);
        this.dumpCameraBezier(rangeCurve);
        this.dumpCameraBezier(projCurve);
    }

    private void dumpCameraBezier(BezierParam bezier) throws IOException {
        this.dumpByte(bezier.getP1x());
        this.dumpByte(bezier.getP2x());
        this.dumpByte(bezier.getP1y());
        this.dumpByte(bezier.getP2y());
    }
}

