/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.sfjp.mikutoga.bin.export.BinaryExporter;
import jp.sfjp.mikutoga.math.MkVec3D;
import jp.sfjp.mikutoga.vmd.model.LuminousColor;
import jp.sfjp.mikutoga.vmd.model.LuminousMotion;
import jp.sfjp.mikutoga.vmd.model.ShadowMode;
import jp.sfjp.mikutoga.vmd.model.ShadowMotion;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;

class LightingExporter
extends BinaryExporter {
    LightingExporter(OutputStream stream) {
        super(stream);
    }

    void dumpLuminousMotion(VmdMotion motion) throws IOException {
        List<LuminousMotion> list = motion.getLuminousMotionList();
        int count = list.size();
        this.dumpLeInt(count);
        for (LuminousMotion luminousMotion : list) {
            int frame = luminousMotion.getFrameNumber();
            this.dumpLeInt(frame);
            LuminousColor color = luminousMotion.getColor();
            this.dumpLeFloat(color.getColR());
            this.dumpLeFloat(color.getColG());
            this.dumpLeFloat(color.getColB());
            MkVec3D vector = luminousMotion.getDirection();
            this.dumpLeFloat((float)vector.getXVal());
            this.dumpLeFloat((float)vector.getYVal());
            this.dumpLeFloat((float)vector.getZVal());
        }
    }

    void dumpShadowMotion(VmdMotion motion) throws IOException {
        List<ShadowMotion> list = motion.getShadowMotionList();
        int count = list.size();
        this.dumpLeInt(count);
        for (ShadowMotion shadowMotion : list) {
            int frame = shadowMotion.getFrameNumber();
            this.dumpLeInt(frame);
            ShadowMode mode = shadowMotion.getShadowMode();
            byte shadowType = mode.getEncodedByte();
            this.dumpByte(shadowType);
            float rawParam = (float)shadowMotion.getRawScopeParam();
            this.dumpLeFloat(rawParam);
        }
    }
}

