/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.OutputStream;
import jp.sfjp.mikutoga.bin.export.IllegalTextExportException;
import jp.sfjp.mikutoga.vmd.IllegalVmdDataException;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.binio.BasicExporter;
import jp.sfjp.mikutoga.vmd.model.binio.BoolExporter;
import jp.sfjp.mikutoga.vmd.model.binio.CameraExporter;
import jp.sfjp.mikutoga.vmd.model.binio.LightingExporter;

public class VmdExporter {
    private BasicExporter basicExporter = null;
    private CameraExporter cameraExporter = null;
    private LightingExporter lightingExporter = null;
    private BoolExporter boolExporter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpVmdMotion(VmdMotion motion, OutputStream ostream) throws IOException, IllegalVmdDataException {
        this.basicExporter = new BasicExporter(ostream);
        this.cameraExporter = new CameraExporter(ostream);
        this.lightingExporter = new LightingExporter(ostream);
        this.boolExporter = new BoolExporter(ostream);
        try {
            this.dumpVmdMotionImpl(motion);
        }
        finally {
            ostream.flush();
        }
    }

    private void dumpVmdMotionImpl(VmdMotion motion) throws IOException, IllegalVmdDataException {
        this.basicExporter.dumpHeader(motion);
        try {
            this.basicExporter.dumpModelName(motion);
            this.basicExporter.dumpBoneMotion(motion);
            this.basicExporter.dumpMorphMotion(motion);
        }
        catch (IllegalTextExportException e) {
            throw new IllegalVmdDataException(e);
        }
        this.cameraExporter.dumpCameraMotion(motion);
        this.lightingExporter.dumpLuminousMotion(motion);
        this.lightingExporter.dumpShadowMotion(motion);
        if (motion.getNumberedFlagList().isEmpty()) {
            return;
        }
        try {
            this.boolExporter.dumpNumberedFlagMotion(motion);
        }
        catch (IllegalTextExportException e) {
            throw new IllegalVmdDataException(e);
        }
    }
}

