/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.InputStream;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.binio.BasicLoader;
import jp.sfjp.mikutoga.vmd.model.binio.BoolLoader;
import jp.sfjp.mikutoga.vmd.model.binio.CameraLoader;
import jp.sfjp.mikutoga.vmd.model.binio.LightingLoader;
import jp.sfjp.mikutoga.vmd.parser.VmdParser;

public class VmdLoader {
    private static final String ERR_TRYLOAD = "try loading first.";
    private static final String ERR_LOADED = "has been loaded.";
    private boolean loaded = false;
    private boolean hasMoreData = true;
    private boolean redundantCheck = false;

    public boolean hasMoreData() throws IllegalStateException {
        if (!this.loaded) {
            throw new IllegalStateException(ERR_TRYLOAD);
        }
        return this.hasMoreData;
    }

    public void setRedundantCheck(boolean mode) {
        this.redundantCheck = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmdMotion load(InputStream source) throws IOException, MmdFormatException, IllegalStateException {
        if (this.loaded) {
            throw new IllegalStateException(ERR_LOADED);
        }
        VmdMotion motion = new VmdMotion();
        VmdParser parser = new VmdParser(source);
        parser.setRedundantCheck(this.redundantCheck);
        BasicLoader basicBuilder = new BasicLoader(motion);
        CameraLoader cameraBuilder = new CameraLoader(motion);
        LightingLoader lightingBuilder = new LightingLoader(motion);
        BoolLoader boolBuilder = new BoolLoader(motion);
        parser.setBasicHandler(basicBuilder);
        parser.setCameraHandler(cameraBuilder);
        parser.setLightingHandler(lightingBuilder);
        parser.setBoolHandler(boolBuilder);
        try {
            parser.parseVmd();
            this.hasMoreData = basicBuilder.hasMoreData();
        }
        finally {
            this.loaded = true;
        }
        return motion;
    }
}

