/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import java.io.IOException;
import java.util.List;
import jp.sfjp.mikutoga.math.MkPos3D;
import jp.sfjp.mikutoga.vmd.model.BezierParam;
import jp.sfjp.mikutoga.vmd.model.CameraMotion;
import jp.sfjp.mikutoga.vmd.model.CameraRotation;
import jp.sfjp.mikutoga.vmd.model.PosCurve;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.ExtraXmlExporter;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.vmd.model.xml.VmdXmlExporter;
import jp.sfjp.mikutoga.xml.ProxyXmlExporter;

class CameraXmlExporter
extends ProxyXmlExporter {
    private final ExtraXmlExporter extraExporter;

    CameraXmlExporter(VmdXmlExporter delegate) {
        super(delegate);
        this.extraExporter = new ExtraXmlExporter(delegate);
    }

    void putCameraSequence(VmdMotion vmdMotion) throws IOException {
        List<CameraMotion> list = vmdMotion.getCameraMotionList();
        if (!list.isEmpty()) {
            this.ind().putBlockComment("  camera-rotation has polar-coordinates parameters.\n  xRad = -radian(UI_X) [latitude]\n  yRad =  radian(UI_Y) [longitude]\n  zRad =  radian(UI_Z) [roll]\n  range = -(UI_RANGE)");
            this.ind().putBlockComment("  motion-interpolation is described with Bezier-cubic-curve.\n  implicit bezier curve point : P0=(0,0) P3=(127,127)\n  defLinear : MMD default linear curve. P1=(20,20) P2=(107,107) [DEFAULT]\n  defEaseInOut : MMD default ease-in-out curve. P1=(64,0) P2=(64,127)");
        }
        this.ind().putSimpleSTag(VmdTag.CAMERA_SEQUENCE.tag()).ln();
        this.pushNest();
        if (!list.isEmpty()) {
            this.ln();
        }
        for (CameraMotion camera : list) {
            this.putCameraMotion(camera);
        }
        this.popNest();
        this.ind().putETag(VmdTag.CAMERA_SEQUENCE.tag()).ln(2);
    }

    private void putCameraMotion(CameraMotion cameraMotion) throws IOException {
        this.ind().putOpenSTag(VmdTag.CAMERA_MOTION.tag()).sp();
        int frameNo = cameraMotion.getFrameNumber();
        this.putIntAttr("frame", frameNo).sp();
        if (!cameraMotion.hasPerspective()) {
            this.putAttr("hasPerspective", "false").sp();
        }
        this.putCloseSTag().ln();
        this.pushNest();
        this.putCameraTarget(cameraMotion);
        this.putCameraRotation(cameraMotion);
        this.putCameraRange(cameraMotion);
        this.putProjection(cameraMotion);
        this.popNest();
        this.ind().putETag(VmdTag.CAMERA_MOTION.tag()).ln(2);
    }

    private void putCameraTarget(CameraMotion cameraMotion) throws IOException {
        this.ind().putOpenSTag(VmdTag.CAMERA_TARGET.tag()).sp();
        MkPos3D position = cameraMotion.getCameraTarget();
        float xPos = (float)position.getXpos();
        float yPos = (float)position.getYpos();
        float zPos = (float)position.getZpos();
        this.putFloatAttr("xPos", xPos).sp();
        this.putFloatAttr("yPos", yPos).sp();
        this.putFloatAttr("zPos", zPos).sp();
        PosCurve posCurve = cameraMotion.getTargetPosCurve();
        if (posCurve.isDefaultLinear()) {
            this.putCloseEmpty().ln();
        } else {
            this.putCloseSTag().ln();
            this.pushNest();
            this.extraExporter.putPositionCurve(posCurve);
            this.popNest();
            this.ind().putETag(VmdTag.CAMERA_TARGET.tag()).ln();
        }
    }

    private void putCameraRotation(CameraMotion cameraMotion) throws IOException {
        this.ind().putOpenSTag(VmdTag.CAMERA_ROTATION.tag()).sp();
        CameraRotation rotation = cameraMotion.getCameraRotation();
        float latitude = (float)rotation.getLatitude();
        float longitude = (float)rotation.getLongitude();
        float roll = (float)rotation.getRoll();
        this.putFloatAttr("xRad", latitude).sp();
        this.putFloatAttr("yRad", longitude).sp();
        this.putFloatAttr("zRad", roll).sp();
        BezierParam rotCurve = cameraMotion.getIntpltRotation();
        if (rotCurve.isDefaultLinear()) {
            this.putCloseEmpty().ln();
        } else {
            this.putCloseSTag().ln();
            this.pushNest();
            this.ind();
            this.extraExporter.putBezierCurve(rotCurve);
            this.ln();
            this.popNest();
            this.ind().putETag(VmdTag.CAMERA_ROTATION.tag()).ln();
        }
    }

    private void putCameraRange(CameraMotion cameraMotion) throws IOException {
        this.ind().putOpenSTag(VmdTag.CAMERA_RANGE.tag()).sp();
        float range = (float)cameraMotion.getRange();
        this.putFloatAttr("range", range).sp();
        BezierParam rangeCurve = cameraMotion.getIntpltRange();
        if (rangeCurve.isDefaultLinear()) {
            this.putCloseEmpty().ln();
        } else {
            this.putCloseSTag().ln();
            this.pushNest();
            this.ind();
            this.extraExporter.putBezierCurve(rangeCurve);
            this.ln();
            this.popNest();
            this.ind().putETag(VmdTag.CAMERA_RANGE.tag()).ln();
        }
    }

    private void putProjection(CameraMotion cameraMotion) throws IOException {
        this.ind().putOpenSTag(VmdTag.PROJECTION.tag()).sp();
        int angle = cameraMotion.getProjectionAngle();
        this.putIntAttr("vertDeg", angle).sp();
        BezierParam projCurve = cameraMotion.getIntpltProjection();
        if (projCurve.isDefaultLinear()) {
            this.putCloseEmpty().ln();
        } else {
            this.putCloseSTag().ln();
            this.pushNest();
            this.ind();
            this.extraExporter.putBezierCurve(projCurve);
            this.ln();
            this.popNest();
            this.ind().putETag(VmdTag.PROJECTION.tag()).ln();
        }
    }
}

