/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import java.io.IOException;
import jp.sfjp.mikutoga.vmd.model.BezierParam;
import jp.sfjp.mikutoga.vmd.model.PosCurve;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.xml.ProxyXmlExporter;
import jp.sfjp.mikutoga.xml.XmlExporter;

class ExtraXmlExporter
extends ProxyXmlExporter {
    ExtraXmlExporter(XmlExporter delegate) {
        super(delegate);
    }

    void putPositionCurve(PosCurve posCurve) throws IOException {
        BezierParam xCurve = posCurve.getIntpltXpos();
        BezierParam yCurve = posCurve.getIntpltYpos();
        BezierParam zCurve = posCurve.getIntpltZpos();
        this.ind().putLineComment("X-Y-Z interpolation *3").ln();
        this.ind();
        this.putBezierCurve(xCurve);
        this.ln();
        this.ind();
        this.putBezierCurve(yCurve);
        this.ln();
        this.ind();
        this.putBezierCurve(zCurve);
        this.ln();
    }

    void putBezierCurve(BezierParam bezier) throws IOException {
        if (bezier.isDefaultLinear()) {
            this.putSimpleEmpty(VmdTag.DEF_LINEAR.tag());
        } else if (bezier.isDefaultEaseInOut()) {
            this.putSimpleEmpty(VmdTag.DEF_EASE_IN_OUT.tag());
        } else {
            this.putOpenSTag(VmdTag.BEZIER.tag()).sp();
            byte p1x = bezier.getP1x();
            byte p1y = bezier.getP1y();
            byte p2x = bezier.getP2x();
            byte p2y = bezier.getP2y();
            this.putIntAttr("p1x", p1x).sp();
            this.putIntAttr("p1y", p1y).sp();
            this.putIntAttr("p2x", p2x).sp();
            this.putIntAttr("p2y", p2y).sp();
            this.putCloseEmpty();
        }
    }
}

