/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import jp.sfjp.mikutoga.typical.TypicalBone;
import jp.sfjp.mikutoga.vmd.model.IkSwitch;
import jp.sfjp.mikutoga.vmd.model.NumberedVmdFlag;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.vmd.model.xml.VmdXmlExporter;
import jp.sfjp.mikutoga.xml.ProxyXmlExporter;

class FlagXmlExporter
extends ProxyXmlExporter {
    private static final String MSG_MAYBE = "Perhaps : [{0}]";

    FlagXmlExporter(VmdXmlExporter delegate) {
        super(delegate);
    }

    private static String toXsdBoolean(boolean bool) {
        String result = bool ? "true" : "false";
        return result;
    }

    void putFlagSequence(VmdMotion vmdMotion) throws IOException {
        this.ind().putSimpleSTag(VmdTag.FLAG_SEQUENCE.tag()).ln();
        this.pushNest();
        List<NumberedVmdFlag> list = vmdMotion.getNumberedFlagList();
        if (!list.isEmpty()) {
            this.ln();
        }
        for (NumberedVmdFlag flag : list) {
            this.putFlagMotion(flag);
        }
        this.popNest();
        this.ind().putETag(VmdTag.FLAG_SEQUENCE.tag()).ln(2);
    }

    private void putFlagMotion(NumberedVmdFlag flag) throws IOException {
        int frameNo = flag.getFrameNumber();
        String showTxt = FlagXmlExporter.toXsdBoolean(flag.isModelShown());
        this.ind().putOpenSTag(VmdTag.FLAG_MOTION.tag()).sp();
        this.putIntAttr("frame", frameNo).sp();
        this.putAttr("showModel", showTxt).sp();
        List<IkSwitch> ikList = flag.getIkSwitchList();
        if (ikList.isEmpty()) {
            this.putCloseEmpty().ln(2);
        } else {
            this.putCloseSTag().ln(2);
            this.pushNest();
            for (IkSwitch ikSw : ikList) {
                this.putIkSwitch(ikSw);
            }
            this.popNest();
            this.ind().putETag(VmdTag.FLAG_MOTION.tag()).ln(2);
        }
    }

    private void putIkSwitch(IkSwitch ikSw) throws IOException {
        String boneName = ikSw.getBoneName();
        String validTxt = FlagXmlExporter.toXsdBoolean(ikSw.isValid());
        this.ind().putLineComment(boneName);
        String globalName = TypicalBone.primary2global(boneName);
        if (globalName != null) {
            String gname = MessageFormat.format(MSG_MAYBE, globalName);
            this.sp(2).putLineComment(gname);
        }
        this.ln();
        this.ind().putOpenSTag(VmdTag.IK_SWITCH.tag()).sp();
        this.putAttr("name", boneName).sp();
        this.putAttr("valid", validTxt).sp();
        this.putCloseEmpty().ln(2);
    }
}

