/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import java.io.IOException;
import java.util.List;
import jp.sfjp.mikutoga.math.MkVec3D;
import jp.sfjp.mikutoga.vmd.model.LuminousColor;
import jp.sfjp.mikutoga.vmd.model.LuminousMotion;
import jp.sfjp.mikutoga.vmd.model.ShadowMode;
import jp.sfjp.mikutoga.vmd.model.ShadowMotion;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.xml.ProxyXmlExporter;
import jp.sfjp.mikutoga.xml.XmlExporter;

class LightingXmlExpoter
extends ProxyXmlExporter {
    LightingXmlExpoter(XmlExporter delegate) {
        super(delegate);
    }

    void putLuminousSequence(VmdMotion vmdMotion) throws IOException {
        this.ind().putSimpleSTag(VmdTag.LUMI_SEQUENCE.tag()).ln();
        this.pushNest();
        List<LuminousMotion> list = vmdMotion.getLuminousMotionList();
        if (!list.isEmpty()) {
            this.ln();
        }
        for (LuminousMotion luminous : list) {
            this.putLuminousMotion(luminous);
        }
        this.popNest();
        this.ind().putETag(VmdTag.LUMI_SEQUENCE.tag()).ln(2);
    }

    private void putLuminousMotion(LuminousMotion luminousMotion) throws IOException {
        this.ind().putOpenSTag(VmdTag.LUMINOUS_ACT.tag()).sp();
        int frameNo = luminousMotion.getFrameNumber();
        this.putIntAttr("frame", frameNo).sp();
        this.putCloseSTag().ln();
        LuminousColor color = luminousMotion.getColor();
        MkVec3D vector = luminousMotion.getDirection();
        this.pushNest();
        this.putLuminousColor(color);
        this.putLuminousDirection(vector);
        this.popNest();
        this.ind().putETag(VmdTag.LUMINOUS_ACT.tag()).ln(2);
    }

    private void putLuminousColor(LuminousColor color) throws IOException {
        this.ind().putOpenSTag(VmdTag.LUMI_COLOR.tag()).sp();
        float colR = color.getColR();
        float colG = color.getColG();
        float colB = color.getColB();
        this.putFloatAttr("rCol", colR).sp();
        this.putFloatAttr("gCol", colG).sp();
        this.putFloatAttr("bCol", colB).sp();
        this.putCloseEmpty().ln();
    }

    private void putLuminousDirection(MkVec3D vector) throws IOException {
        this.ind().putOpenSTag(VmdTag.LUMI_DIRECTION.tag()).sp();
        float xVec = (float)vector.getXVal();
        float yVec = (float)vector.getYVal();
        float zVec = (float)vector.getZVal();
        this.putFloatAttr("xVec", xVec).sp();
        this.putFloatAttr("yVec", yVec).sp();
        this.putFloatAttr("zVec", zVec).sp();
        this.putCloseEmpty().ln();
    }

    void putShadowSequence(VmdMotion vmdMotion) throws IOException {
        List<ShadowMotion> list = vmdMotion.getShadowMotionList();
        if (!list.isEmpty()) {
            this.ind().putBlockComment("  UI_VALUE = EFFECTIVE_RANGE * 100 ???\n  rawParam = 0.1 - (UI_VALUE / 1.0E+5)\n\n  NONE   : no self-shadow\n  MODE_1 : reduce shadow-quality suddenly at range\n  MODE_2 : reduce shadow-quality gradually with range");
        }
        this.ind().putSimpleSTag(VmdTag.SHADOW_SEQUENCE.tag()).ln();
        this.pushNest();
        for (ShadowMotion shadow : list) {
            this.putShadowMotion(shadow);
        }
        this.popNest();
        this.ind().putETag(VmdTag.SHADOW_SEQUENCE.tag()).ln(2);
    }

    private void putShadowMotion(ShadowMotion shadowMotion) throws IOException {
        this.ind().putOpenSTag(VmdTag.SHADOW_ACT.tag()).sp();
        int frameNo = shadowMotion.getFrameNumber();
        ShadowMode mode = shadowMotion.getShadowMode();
        float rawParam = (float)shadowMotion.getRawScopeParam();
        this.putIntAttr("frame", frameNo).sp();
        this.putAttr("mode", mode.name()).sp();
        this.putFloatAttr("rawParam", rawParam).sp();
        this.putCloseEmpty();
        double uiVal = ShadowMotion.rawParamToScope(rawParam);
        long lVal = Math.round(uiVal);
        this.sp().putLineComment("UI:" + lVal).ln();
    }
}

