/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import java.util.List;
import jp.sfjp.mikutoga.math.MkPos3D;
import jp.sfjp.mikutoga.vmd.model.BezierParam;
import jp.sfjp.mikutoga.vmd.model.CameraMotion;
import jp.sfjp.mikutoga.vmd.model.CameraRotation;
import jp.sfjp.mikutoga.vmd.model.PosCurve;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.SaxVmdListener;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.xml.SaxAttr;
import org.xml.sax.Attributes;

class SaxCameraListener
extends SaxVmdListener {
    private CameraMotion currentCamera = null;

    SaxCameraListener() {
    }

    @Override
    void openTag(VmdTag tag, Attributes attr) {
        switch (tag) {
            case CAMERA_MOTION: {
                this.openCameraMotion(attr);
                break;
            }
            case CAMERA_TARGET: {
                this.openCameraTarget(attr);
                break;
            }
            case CAMERA_ROTATION: {
                this.openCameraRotation(attr);
                break;
            }
            case CAMERA_RANGE: {
                this.openCameraRange(attr);
                break;
            }
            case PROJECTION: {
                this.openProjection(attr);
                break;
            }
            default: {
                super.openTag(tag, attr);
            }
        }
    }

    @Override
    void closeTag(VmdTag tag) {
        switch (tag) {
            case CAMERA_MOTION: {
                this.closeCameraMotion();
                break;
            }
            case CAMERA_TARGET: {
                this.setCurrentPosCurve(null);
                break;
            }
            case CAMERA_ROTATION: 
            case CAMERA_RANGE: 
            case PROJECTION: {
                this.setCurrentBezierParam(null);
                break;
            }
            default: {
                super.closeTag(tag);
            }
        }
    }

    private void openCameraMotion(Attributes attr) {
        this.currentCamera = new CameraMotion();
        int frameNo = SaxAttr.getIntAttr(attr, "frame");
        this.currentCamera.setFrameNumber(frameNo);
        boolean hasPerspective = SaxAttr.getBooleanAttr(attr, "hasPerspective", true);
        this.currentCamera.setPerspectiveMode(hasPerspective);
    }

    private void closeCameraMotion() {
        VmdMotion motion = this.getVmdMotion();
        List<CameraMotion> cameraList = motion.getCameraMotionList();
        cameraList.add(this.currentCamera);
        this.currentCamera = null;
    }

    private void openCameraTarget(Attributes attr) {
        MkPos3D targetPos = this.currentCamera.getCameraTarget();
        float xPos = SaxAttr.getFloatAttr(attr, "xPos");
        float yPos = SaxAttr.getFloatAttr(attr, "yPos");
        float zPos = SaxAttr.getFloatAttr(attr, "zPos");
        targetPos.setPosition(xPos, yPos, zPos);
        PosCurve curve = this.currentCamera.getTargetPosCurve();
        this.setCurrentPosCurve(curve);
    }

    private void openCameraRotation(Attributes attr) {
        CameraRotation cameraRotation = this.currentCamera.getCameraRotation();
        float latitude = SaxAttr.getFloatAttr(attr, "xRad");
        float longitude = SaxAttr.getFloatAttr(attr, "yRad");
        float roll = SaxAttr.getFloatAttr(attr, "zRad");
        cameraRotation.setLatitude(latitude);
        cameraRotation.setLongitude(longitude);
        cameraRotation.setRoll(roll);
        BezierParam bez = this.currentCamera.getIntpltRotation();
        this.setCurrentBezierParam(bez);
    }

    private void openCameraRange(Attributes attr) {
        float range = SaxAttr.getFloatAttr(attr, "range");
        this.currentCamera.setRange(range);
        BezierParam bez = this.currentCamera.getIntpltRange();
        this.setCurrentBezierParam(bez);
    }

    private void openProjection(Attributes attr) {
        int vertDeg = SaxAttr.getIntAttr(attr, "vertDeg");
        this.currentCamera.setProjectionAngle(vertDeg);
        BezierParam bez = this.currentCamera.getIntpltProjection();
        this.setCurrentBezierParam(bez);
    }
}

