/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import java.util.List;
import jp.sfjp.mikutoga.vmd.model.IkSwitch;
import jp.sfjp.mikutoga.vmd.model.NumberedVmdFlag;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.SaxVmdListener;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.xml.SaxAttr;
import org.xml.sax.Attributes;

class SaxFlagListener
extends SaxVmdListener {
    private NumberedVmdFlag currentFlagMotion = null;

    SaxFlagListener() {
    }

    @Override
    void openTag(VmdTag tag, Attributes attr) {
        switch (tag) {
            case FLAG_MOTION: {
                this.openFlagMotion(attr);
                break;
            }
            case IK_SWITCH: {
                this.openIkSwitch(attr);
                break;
            }
        }
    }

    @Override
    void closeTag(VmdTag tag) {
        if (tag == VmdTag.FLAG_MOTION) {
            this.closeFlagMotion();
        }
    }

    private void openFlagMotion(Attributes attr) {
        this.currentFlagMotion = new NumberedVmdFlag();
        int frameNo = SaxAttr.getIntAttr(attr, "frame");
        boolean showModel = SaxAttr.getBooleanAttr(attr, "showModel");
        this.currentFlagMotion.setFrameNumber(frameNo);
        this.currentFlagMotion.setModelShown(showModel);
    }

    private void closeFlagMotion() {
        VmdMotion motion = this.getVmdMotion();
        List<NumberedVmdFlag> flagList = motion.getNumberedFlagList();
        flagList.add(this.currentFlagMotion);
        this.currentFlagMotion = null;
    }

    private void openIkSwitch(Attributes attr) {
        String boneName = SaxAttr.getStringAttr(attr, "name");
        boolean valid = SaxAttr.getBooleanAttr(attr, "valid");
        IkSwitch ikSw = new IkSwitch();
        ikSw.setBoneName(boneName);
        ikSw.setValid(valid);
        List<IkSwitch> ikList = this.currentFlagMotion.getIkSwitchList();
        ikList.add(ikSw);
    }
}

