/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import java.util.List;
import jp.sfjp.mikutoga.math.MkVec3D;
import jp.sfjp.mikutoga.vmd.model.LuminousColor;
import jp.sfjp.mikutoga.vmd.model.LuminousMotion;
import jp.sfjp.mikutoga.vmd.model.ShadowMode;
import jp.sfjp.mikutoga.vmd.model.ShadowMotion;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.SaxVmdListener;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.xml.SaxAttr;
import org.xml.sax.Attributes;

class SaxLightingListener
extends SaxVmdListener {
    private LuminousMotion currentLuminous = null;

    SaxLightingListener() {
    }

    @Override
    void openTag(VmdTag tag, Attributes attr) {
        switch (tag) {
            case LUMINOUS_ACT: {
                this.openLumiAct(attr);
                break;
            }
            case LUMI_COLOR: {
                this.openLumiColor(attr);
                break;
            }
            case LUMI_DIRECTION: {
                this.openLumiDirection(attr);
                break;
            }
            case SHADOW_ACT: {
                this.openShadowAct(attr);
                break;
            }
        }
    }

    @Override
    void closeTag(VmdTag tag) {
        if (tag == VmdTag.LUMINOUS_ACT) {
            this.closeLumiAct();
        }
    }

    private void openLumiAct(Attributes attr) {
        this.currentLuminous = new LuminousMotion();
        int frameNo = SaxAttr.getIntAttr(attr, "frame");
        this.currentLuminous.setFrameNumber(frameNo);
    }

    private void closeLumiAct() {
        VmdMotion motion = this.getVmdMotion();
        List<LuminousMotion> lumiList = motion.getLuminousMotionList();
        lumiList.add(this.currentLuminous);
        this.currentLuminous = null;
    }

    private void openLumiColor(Attributes attr) {
        LuminousColor color = this.currentLuminous.getColor();
        float rCol = SaxAttr.getFloatAttr(attr, "rCol");
        float gCol = SaxAttr.getFloatAttr(attr, "gCol");
        float bCol = SaxAttr.getFloatAttr(attr, "bCol");
        color.setColR(rCol);
        color.setColG(gCol);
        color.setColB(bCol);
    }

    private void openLumiDirection(Attributes attr) {
        MkVec3D vec = this.currentLuminous.getDirection();
        float xVec = SaxAttr.getFloatAttr(attr, "xVec");
        float yVec = SaxAttr.getFloatAttr(attr, "yVec");
        float zVec = SaxAttr.getFloatAttr(attr, "zVec");
        vec.setXVal(xVec);
        vec.setYVal(yVec);
        vec.setZVal(zVec);
    }

    private void openShadowAct(Attributes attr) {
        ShadowMotion shadowMotion = new ShadowMotion();
        int frameNo = SaxAttr.getIntAttr(attr, "frame");
        shadowMotion.setFrameNumber(frameNo);
        float rawParam = SaxAttr.getFloatAttr(attr, "rawParam");
        shadowMotion.setRawScopeParam(rawParam);
        String modeAttr = SaxAttr.getStringAttr(attr, "mode");
        ShadowMode mode = ShadowMode.valueOf(modeAttr);
        shadowMotion.setShadowMode(mode);
        VmdMotion motion = this.getVmdMotion();
        List<ShadowMotion> shadowList = motion.getShadowMotionList();
        shadowList.add(shadowMotion);
    }
}

