/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import jp.sfjp.mikutoga.math.MkPos3D;
import jp.sfjp.mikutoga.math.MkQuat;
import jp.sfjp.mikutoga.vmd.model.BezierParam;
import jp.sfjp.mikutoga.vmd.model.BoneMotion;
import jp.sfjp.mikutoga.vmd.model.MorphMotion;
import jp.sfjp.mikutoga.vmd.model.PosCurve;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.SaxVmdListener;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.xml.SaxAttr;
import org.xml.sax.Attributes;

class SaxMotionListener
extends SaxVmdListener {
    private BoneMotion boneMotion;
    private String boneName;
    private String morphName;

    SaxMotionListener() {
    }

    @Override
    void openTag(VmdTag tag, Attributes attr) {
        switch (tag) {
            case BONE_PART: {
                this.openBonePart(attr);
                break;
            }
            case BONE_MOTION: {
                this.openBoneMotion(attr);
                break;
            }
            case BONE_POSITION: {
                this.openBonePosition(attr);
                break;
            }
            case BONE_ROT_QUAT: {
                this.openBoneRotQuat(attr);
                break;
            }
            case BONE_ROT_EYXZ: {
                this.openBoneRotEyxz(attr);
                break;
            }
            case MORPH_PART: {
                this.openMorphPart(attr);
                break;
            }
            case MORPH_MOTION: {
                this.openMorphMotion(attr);
                break;
            }
            default: {
                super.openTag(tag, attr);
            }
        }
    }

    @Override
    void closeTag(VmdTag tag) {
        switch (tag) {
            case BONE_MOTION: {
                this.closeBoneMotion();
                break;
            }
            case BONE_POSITION: {
                this.setCurrentPosCurve(null);
                break;
            }
            case BONE_ROT_QUAT: 
            case BONE_ROT_EYXZ: {
                this.setCurrentBezierParam(null);
                break;
            }
            default: {
                super.closeTag(tag);
            }
        }
    }

    private void openBonePart(Attributes attr) {
        this.boneName = SaxAttr.getStringAttr(attr, "name");
    }

    private void openBoneMotion(Attributes attr) {
        this.boneMotion = new BoneMotion();
        this.boneMotion.setBoneName(this.boneName);
        int frameNo = SaxAttr.getIntAttr(attr, "frame");
        this.boneMotion.setFrameNumber(frameNo);
    }

    private void closeBoneMotion() {
        VmdMotion motion = this.getVmdMotion();
        motion.addBoneMotion(this.boneMotion);
    }

    private void openBonePosition(Attributes attr) {
        MkPos3D position = this.boneMotion.getPosition();
        float xPos = SaxAttr.getFloatAttr(attr, "xPos");
        float yPos = SaxAttr.getFloatAttr(attr, "yPos");
        float zPos = SaxAttr.getFloatAttr(attr, "zPos");
        position.setXpos(xPos);
        position.setYpos(yPos);
        position.setZpos(zPos);
        PosCurve curve = this.boneMotion.getPosCurve();
        this.setCurrentPosCurve(curve);
    }

    private void openBoneRotQuat(Attributes attr) {
        MkQuat rotation = this.boneMotion.getRotation();
        float qx = SaxAttr.getFloatAttr(attr, "qx");
        float qy = SaxAttr.getFloatAttr(attr, "qy");
        float qz = SaxAttr.getFloatAttr(attr, "qz");
        float qw = SaxAttr.getFloatAttr(attr, "qw");
        rotation.setQ1(qx);
        rotation.setQ2(qy);
        rotation.setQ3(qz);
        rotation.setQW(qw);
        BezierParam bez = this.boneMotion.getIntpltRotation();
        this.setCurrentBezierParam(bez);
    }

    private void openBoneRotEyxz(Attributes attr) {
        MkQuat rotation = this.boneMotion.getRotation();
        float xDeg = SaxAttr.getFloatAttr(attr, "xDeg");
        float yDeg = SaxAttr.getFloatAttr(attr, "yDeg");
        float zDeg = SaxAttr.getFloatAttr(attr, "zDeg");
        float xRad = (float)StrictMath.toRadians(xDeg);
        float yRad = (float)StrictMath.toRadians(yDeg);
        float zRad = (float)StrictMath.toRadians(zDeg);
        rotation.setEulerYXZ(xRad, yRad, zRad);
        BezierParam bez = this.boneMotion.getIntpltRotation();
        this.setCurrentBezierParam(bez);
    }

    private void openMorphPart(Attributes attr) {
        this.morphName = SaxAttr.getStringAttr(attr, "name");
    }

    private void openMorphMotion(Attributes attr) {
        MorphMotion morphMotion = new MorphMotion();
        int frameNo = SaxAttr.getIntAttr(attr, "frame");
        float flex = SaxAttr.getFloatAttr(attr, "flex");
        morphMotion.setMorphName(this.morphName);
        morphMotion.setFrameNumber(frameNo);
        morphMotion.setFlex(flex);
        VmdMotion motion = this.getVmdMotion();
        motion.addMorphMotion(morphMotion);
    }
}

