/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import jp.sfjp.mikutoga.vmd.model.BezierParam;
import jp.sfjp.mikutoga.vmd.model.PosCurve;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.xml.SaxAttr;
import org.xml.sax.Attributes;

class SaxVmdListener {
    private VmdMotion vmdMotion = null;
    private PosCurve currentPosCurve = null;
    private int axisIdx = -1;
    private BezierParam currentBezParam = null;

    protected SaxVmdListener() {
    }

    void openTag(VmdTag tag, Attributes attr) {
        switch (tag) {
            case BEZIER: {
                this.openBezier(attr);
                break;
            }
            case DEF_LINEAR: {
                this.openDefLinear();
                break;
            }
            case DEF_EASE_IN_OUT: {
                this.openDefEaseInOut();
                break;
            }
        }
    }

    void closeTag(VmdTag tag) {
    }

    void setVmdMotion(VmdMotion motion) throws NullPointerException {
        if (motion == null) {
            throw new NullPointerException();
        }
        this.vmdMotion = motion;
    }

    protected VmdMotion getVmdMotion() {
        return this.vmdMotion;
    }

    protected void setCurrentPosCurve(PosCurve curve) {
        this.currentPosCurve = curve;
        this.axisIdx = 0;
        this.currentBezParam = null;
    }

    protected void setCurrentBezierParam(BezierParam bez) {
        this.currentBezParam = bez;
        this.currentPosCurve = null;
        this.axisIdx = -1;
    }

    private BezierParam getTargetBezierParam() {
        BezierParam result;
        if (this.currentBezParam != null) {
            return this.currentBezParam;
        }
        if (this.currentPosCurve == null) {
            assert (false);
            throw new AssertionError();
        }
        switch (this.axisIdx) {
            case 0: {
                result = this.currentPosCurve.getIntpltXpos();
                break;
            }
            case 1: {
                result = this.currentPosCurve.getIntpltYpos();
                break;
            }
            case 2: {
                result = this.currentPosCurve.getIntpltZpos();
                break;
            }
            default: {
                assert (false);
                throw new AssertionError();
            }
        }
        ++this.axisIdx;
        return result;
    }

    protected void putBezier(byte p1x, byte p1y, byte p2x, byte p2y) {
        BezierParam bez = this.getTargetBezierParam();
        bez.setP1(p1x, p1y);
        bez.setP2(p2x, p2y);
    }

    protected void openBezier(Attributes attr) {
        byte p1x = SaxAttr.getByteAttr(attr, "p1x");
        byte p1y = SaxAttr.getByteAttr(attr, "p1y");
        byte p2x = SaxAttr.getByteAttr(attr, "p2x");
        byte p2y = SaxAttr.getByteAttr(attr, "p2y");
        this.putBezier(p1x, p1y, p2x, p2y);
    }

    protected void openDefLinear() {
        byte p1x = 20;
        byte p1y = 20;
        byte p2x = 107;
        byte p2y = 107;
        this.putBezier(p1x, p1y, p2x, p2y);
    }

    protected void openDefEaseInOut() {
        byte p1x = 64;
        byte p1y = 0;
        byte p2x = 64;
        byte p2y = 127;
        this.putBezier(p1x, p1y, p2x, p2y);
    }
}

