/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import jp.sfjp.mikutoga.math.EulerYXZ;
import jp.sfjp.mikutoga.math.MkPos3D;
import jp.sfjp.mikutoga.math.MkQuat;
import jp.sfjp.mikutoga.typical.TypicalBone;
import jp.sfjp.mikutoga.typical.TypicalMorph;
import jp.sfjp.mikutoga.vmd.IllegalVmdDataException;
import jp.sfjp.mikutoga.vmd.VmdUniq;
import jp.sfjp.mikutoga.vmd.model.BezierParam;
import jp.sfjp.mikutoga.vmd.model.BoneMotion;
import jp.sfjp.mikutoga.vmd.model.MorphMotion;
import jp.sfjp.mikutoga.vmd.model.PosCurve;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.CameraXmlExporter;
import jp.sfjp.mikutoga.vmd.model.xml.ExtraXmlExporter;
import jp.sfjp.mikutoga.vmd.model.xml.FlagXmlExporter;
import jp.sfjp.mikutoga.vmd.model.xml.LightingXmlExpoter;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.vmd.model.xml.XmlMotionFileType;
import jp.sfjp.mikutoga.xml.BasicXmlExporter;

public class VmdXmlExporter
extends BasicXmlExporter {
    private static final String XML_VER = "1.0";
    private static final String XML_ENC = "UTF-8";
    private static final String XML_DECL = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    private static final String XSINS = "xsi";
    private static final String MSG_MAYBE = "Perhaps : [{0}]";
    private XmlMotionFileType xmlType = XmlMotionFileType.XML_110820;
    private boolean isQuaternionMode = true;
    private String generator = "";
    private final CameraXmlExporter cameraXmlExporter = new CameraXmlExporter(this);
    private final LightingXmlExpoter lightingExporter = new LightingXmlExpoter(this);
    private final ExtraXmlExporter extraExporter = new ExtraXmlExporter(this);
    private final FlagXmlExporter flagXmlExporter = new FlagXmlExporter(this);

    public void setXmlFileType(XmlMotionFileType type) {
        switch (type) {
            case XML_110820: 
            case XML_130609: {
                this.xmlType = type;
                break;
            }
            case XML_AUTO: {
                this.xmlType = XmlMotionFileType.XML_130609;
                break;
            }
            default: {
                assert (false);
                throw new AssertionError();
            }
        }
        assert (this.xmlType == XmlMotionFileType.XML_110820 || this.xmlType == XmlMotionFileType.XML_130609);
    }

    public XmlMotionFileType getXmlFileType() {
        return this.xmlType;
    }

    public void setQuaternionMode(boolean mode) {
        this.isQuaternionMode = mode;
    }

    public boolean isQuaternionMode() {
        return this.isQuaternionMode;
    }

    public void setGenerator(String generatorArg) {
        this.generator = generatorArg;
    }

    public String getGenerator() {
        return this.generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putVmdXml(VmdMotion vmdMotion, Appendable xmlOut) throws IOException, IllegalVmdDataException {
        this.setAppendable(xmlOut);
        try {
            this.putVmdXmlImpl(vmdMotion);
        }
        finally {
            this.flush();
        }
    }

    private void putVmdXmlImpl(VmdMotion vmdMotion) throws IOException, IllegalVmdDataException {
        this.putVmdRootOpen();
        this.putGenerator();
        if (vmdMotion.isModelMotion()) {
            this.putModelName(vmdMotion);
            this.putBoneMotionSequence(vmdMotion);
            this.putMorphSequence(vmdMotion);
            if (this.xmlType == XmlMotionFileType.XML_130609) {
                this.flagXmlExporter.putFlagSequence(vmdMotion);
            }
        } else {
            this.cameraXmlExporter.putCameraSequence(vmdMotion);
            this.lightingExporter.putLuminousSequence(vmdMotion);
            this.lightingExporter.putShadowSequence(vmdMotion);
        }
        this.ind().putETag(VmdTag.VMD_MOTION.tag()).ln(2);
        this.ind().putLineComment("EOF").ln();
    }

    private void putVmdRootOpen() throws IOException {
        String schemaVer;
        String schemaUrl;
        String namespace;
        this.ind().putRawText(XML_DECL).ln(2);
        this.ind().putBlockComment("  MikuMikuDance\n    motion-data(*.vmd) on XML").ln(2);
        switch (this.xmlType) {
            case XML_110820: {
                namespace = "http://mikutoga.sourceforge.jp/xml/ns/vmdxml/110820";
                schemaUrl = "http://mikutoga.sourceforge.jp/xml/xsd/vmdxml-110820.xsd";
                schemaVer = "110820";
                break;
            }
            case XML_130609: {
                namespace = "http://mikutoga.sourceforge.jp/xml/ns/vmdxml/130609";
                schemaUrl = "http://mikutoga.sourceforge.jp/xml/xsd/vmdxml-130609.xsd";
                schemaVer = "130609";
                break;
            }
            default: {
                assert (false);
                throw new AssertionError();
            }
        }
        this.ind().putOpenSTag(VmdTag.VMD_MOTION.tag()).ln();
        this.pushNest();
        this.ind().putAttr("xmlns", namespace).ln();
        this.ind().putAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").ln();
        this.ind().putRawText(XSINS).putRawText(":schemaLocation=").putRawCh('\"');
        this.putRawText(namespace).ln();
        this.ind().sp(2).putRawText(schemaUrl).putRawCh('\"').ln();
        this.ind().putAttr("version", schemaVer).ln();
        this.popNest();
        this.putCloseSTag().ln(2);
    }

    private void putGenerator() throws IOException {
        String genTxt = this.getGenerator();
        if (genTxt == null) {
            return;
        }
        if (genTxt.isEmpty()) {
            return;
        }
        this.ind().putOpenSTag(VmdTag.META.tag()).sp();
        this.putAttr("name", "generator").sp();
        this.putAttr("content", genTxt).sp();
        this.putCloseEmpty().ln(2);
    }

    private void putModelName(VmdMotion vmdMotion) throws IOException {
        String modelName = vmdMotion.getModelName();
        String modelComm = modelName != null && modelName.length() > 0 ? modelName : "[NAMELESS]";
        this.ind().putLineComment(modelComm).ln();
        this.ind().putOpenSTag(VmdTag.MODEL_NAME.tag()).sp();
        this.putAttr("name", modelName).sp();
        this.putCloseEmpty().ln(2);
    }

    private void putBoneMotionSequence(VmdMotion vmdMotion) throws IOException {
        Map<String, List<BoneMotion>> boneMap = vmdMotion.getBonePartMap();
        if (!boneMap.isEmpty()) {
            this.ind().putBlockComment("  bone-rotation has Quaternion parameters [boneRotQuat]\n  or YXZ-Euler angles [boneRotEyxz].\n  Quaternion form is strongly recommended if you are data-exchanging.");
            this.ind().putBlockComment("  motion-interpolation is described with Bezier-cubic-curve.\n  implicit bezier curve point : P0=(0,0) P3=(127,127)\n  defLinear : MMD default linear curve. P1=(20,20) P2=(107,107) [DEFAULT]\n  defEaseInOut : MMD default ease-in-out curve. P1=(64,0) P2=(64,127)");
        }
        this.ind().putSimpleSTag(VmdTag.BONE_M_SEQUENCE.tag()).ln();
        this.pushNest();
        if (!boneMap.isEmpty()) {
            this.ln();
        }
        for (Map.Entry<String, List<BoneMotion>> entry : boneMap.entrySet()) {
            this.putBonePart(entry.getKey(), entry.getValue());
        }
        this.popNest();
        this.ind().putETag(VmdTag.BONE_M_SEQUENCE.tag()).ln(2);
    }

    private void putBonePart(String boneName, List<BoneMotion> list) throws IOException {
        this.ind().putLineComment(boneName);
        String globalName = TypicalBone.primary2global(boneName);
        if (globalName != null) {
            String gname = MessageFormat.format(MSG_MAYBE, globalName);
            this.sp(2).putLineComment(gname);
        }
        this.ln();
        this.ind().putOpenSTag(VmdTag.BONE_PART.tag()).sp();
        this.putAttr("name", boneName).sp();
        this.putCloseSTag().ln(2);
        this.pushNest();
        for (BoneMotion bone : list) {
            this.putBoneMotion(bone);
        }
        this.popNest();
        this.ind().putETag(VmdTag.BONE_PART.tag()).ln(2);
    }

    private void putBoneMotion(BoneMotion boneMotion) throws IOException {
        this.ind().putOpenSTag(VmdTag.BONE_MOTION.tag()).sp();
        int frameNo = boneMotion.getFrameNumber();
        this.putIntAttr("frame", frameNo).sp();
        this.putCloseSTag().ln();
        this.pushNest();
        this.putBonePosition(boneMotion);
        if (this.isQuaternionMode()) {
            this.putBoneRotQuat(boneMotion);
        } else {
            this.putBoneRotEyxz(boneMotion);
        }
        this.popNest();
        this.ind().putETag(VmdTag.BONE_MOTION.tag()).ln(2);
    }

    private void putBonePosition(BoneMotion boneMotion) throws IOException {
        if (boneMotion.hasImplicitPosition()) {
            return;
        }
        this.ind().putOpenSTag(VmdTag.BONE_POSITION.tag()).sp();
        MkPos3D position = boneMotion.getPosition();
        float xPos = (float)position.getXpos();
        float yPos = (float)position.getYpos();
        float zPos = (float)position.getZpos();
        this.putFloatAttr("xPos", xPos).sp();
        this.putFloatAttr("yPos", yPos).sp();
        this.putFloatAttr("zPos", zPos).sp();
        PosCurve posCurve = boneMotion.getPosCurve();
        if (posCurve.isDefaultLinear()) {
            this.putCloseEmpty().ln();
        } else {
            this.putCloseSTag().ln();
            this.pushNest();
            this.extraExporter.putPositionCurve(posCurve);
            this.popNest();
            this.ind().putETag(VmdTag.BONE_POSITION.tag()).ln();
        }
    }

    private void putBoneRotQuat(BoneMotion boneMotion) throws IOException {
        MkQuat rotation = boneMotion.getRotation();
        BezierParam rotCurve = boneMotion.getIntpltRotation();
        this.ind().putOpenSTag(VmdTag.BONE_ROT_QUAT.tag()).ln();
        this.pushNest();
        float qx = (float)rotation.getQ1();
        float qy = (float)rotation.getQ2();
        float qz = (float)rotation.getQ3();
        float qw = (float)rotation.getQW();
        this.ind().putFloatAttr("qx", qx).ln();
        this.ind().putFloatAttr("qy", qy).ln();
        this.ind().putFloatAttr("qz", qz).ln();
        this.ind().putFloatAttr("qw", qw).ln();
        this.popNest();
        this.ind();
        if (rotCurve.isDefaultLinear()) {
            this.putCloseEmpty().ln();
        } else {
            this.putCloseSTag().ln();
            this.pushNest();
            this.ind();
            this.extraExporter.putBezierCurve(rotCurve);
            this.ln();
            this.popNest();
            this.ind().putETag(VmdTag.BONE_ROT_QUAT.tag()).ln();
        }
    }

    private void putBoneRotEyxz(BoneMotion boneMotion) throws IOException {
        MkQuat rotation = boneMotion.getRotation();
        BezierParam rotCurve = boneMotion.getIntpltRotation();
        EulerYXZ euler = new EulerYXZ();
        rotation.toEulerYXZ(euler);
        float xDeg = (float)StrictMath.toDegrees(euler.getXRot());
        float yDeg = (float)StrictMath.toDegrees(euler.getYRot());
        float zDeg = (float)StrictMath.toDegrees(euler.getZRot());
        this.ind().putOpenSTag(VmdTag.BONE_ROT_EYXZ.tag()).ln();
        this.pushNest();
        this.ind().putFloatAttr("xDeg", xDeg).ln();
        this.ind().putFloatAttr("yDeg", yDeg).ln();
        this.ind().putFloatAttr("zDeg", zDeg).ln();
        this.popNest();
        this.ind();
        if (rotCurve.isDefaultLinear()) {
            this.putCloseEmpty().ln();
        } else {
            this.putCloseSTag().ln();
            this.pushNest();
            this.ind();
            this.extraExporter.putBezierCurve(rotCurve);
            this.ln();
            this.popNest();
            this.ind().putETag(VmdTag.BONE_ROT_EYXZ.tag()).ln();
        }
    }

    private void putMorphSequence(VmdMotion vmdMotion) throws IOException {
        this.ind().putSimpleSTag(VmdTag.MORPH_SEQUENCE.tag()).ln();
        this.pushNest();
        Map<String, List<MorphMotion>> listMap = vmdMotion.getMorphPartMap();
        if (!listMap.isEmpty()) {
            this.ln();
        }
        this.putMorphPartList(listMap);
        this.popNest();
        this.ind().putETag(VmdTag.MORPH_SEQUENCE.tag()).ln(2);
    }

    private void putMorphPartList(Map<String, List<MorphMotion>> listMap) throws IOException {
        for (Map.Entry<String, List<MorphMotion>> entry : listMap.entrySet()) {
            String morphName = entry.getKey();
            List<MorphMotion> list = entry.getValue();
            if (VmdUniq.isBaseMorphName(morphName)) continue;
            this.ind().putLineComment(morphName);
            String globalName = TypicalMorph.primary2global(morphName);
            if (globalName != null) {
                String gname = MessageFormat.format(MSG_MAYBE, globalName);
                this.sp(2).putLineComment(gname);
            }
            this.ln();
            this.ind().putOpenSTag(VmdTag.MORPH_PART.tag()).sp();
            this.putAttr("name", morphName).sp();
            this.putCloseSTag().ln();
            this.pushNest();
            for (MorphMotion morph : list) {
                this.putMorphMotion(morph);
            }
            this.popNest();
            this.ind().putETag(VmdTag.MORPH_PART.tag()).ln(2);
        }
    }

    private void putMorphMotion(MorphMotion morphMotion) throws IOException {
        this.ind().putOpenSTag(VmdTag.MORPH_MOTION.tag()).sp();
        int frameNo = morphMotion.getFrameNumber();
        float flex = morphMotion.getFlex();
        this.putIntAttr("frame", frameNo).sp();
        this.putFloatAttr("flex", flex).sp();
        this.putCloseEmpty().ln();
    }
}

