/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.xml;

import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.xml.SaxCameraListener;
import jp.sfjp.mikutoga.vmd.model.xml.SaxFlagListener;
import jp.sfjp.mikutoga.vmd.model.xml.SaxLightingListener;
import jp.sfjp.mikutoga.vmd.model.xml.SaxMotionListener;
import jp.sfjp.mikutoga.vmd.model.xml.SaxVmdListener;
import jp.sfjp.mikutoga.vmd.model.xml.VmdTag;
import jp.sfjp.mikutoga.xml.SaxAttr;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class XmlHandler
implements ContentHandler {
    private VmdMotion vmdMotion;
    private String nspfx = "";
    private String nsuri = null;
    private final SaxVmdListener motionListener = new SaxMotionListener();
    private final SaxVmdListener cameraListener = new SaxCameraListener();
    private final SaxVmdListener lightListener = new SaxLightingListener();
    private final SaxVmdListener flagListener = new SaxFlagListener();
    private SaxVmdListener currentListener = null;

    XmlHandler() {
    }

    VmdMotion getVmdMotion() {
        return this.vmdMotion;
    }

    @Override
    public void startDocument() throws SAXException {
        this.vmdMotion = new VmdMotion();
        this.motionListener.setVmdMotion(this.vmdMotion);
        this.cameraListener.setVmdMotion(this.vmdMotion);
        this.lightListener.setVmdMotion(this.vmdMotion);
        this.flagListener.setVmdMotion(this.vmdMotion);
    }

    @Override
    public void endDocument() throws SAXException {
        assert (this.vmdMotion != null);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if ("http://mikutoga.sourceforge.jp/xml/ns/vmdxml/110820".equals(uri) || "http://mikutoga.sourceforge.jp/xml/ns/vmdxml/130609".equals(uri)) {
            this.nspfx = prefix;
            this.nsuri = uri;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (prefix.equals(this.nspfx)) {
            this.nspfx = "";
            this.nsuri = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        if (!this.nsuri.equals(uri)) {
            return;
        }
        VmdTag tag = VmdTag.parse(localName);
        if (tag == null) {
            return;
        }
        if (tag == VmdTag.MODEL_NAME) {
            String modelName = SaxAttr.getStringAttr(attr, "name");
            this.vmdMotion.setModelName(modelName);
            return;
        }
        this.switchListener(tag);
        if (this.currentListener != null) {
            this.currentListener.openTag(tag, attr);
        }
    }

    private void switchListener(VmdTag tag) {
        switch (tag) {
            case BONE_M_SEQUENCE: 
            case MORPH_SEQUENCE: {
                this.currentListener = this.motionListener;
                break;
            }
            case CAMERA_SEQUENCE: {
                this.currentListener = this.cameraListener;
                break;
            }
            case LUMI_SEQUENCE: 
            case SHADOW_SEQUENCE: {
                this.currentListener = this.lightListener;
                break;
            }
            case FLAG_SEQUENCE: {
                this.currentListener = this.flagListener;
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.nsuri.equals(uri)) {
            return;
        }
        VmdTag tag = VmdTag.parse(localName);
        if (tag == null) {
            return;
        }
        if (this.currentListener != null) {
            this.currentListener.closeTag(tag);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

