/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.parser;

import java.io.IOException;
import java.nio.charset.Charset;
import jp.sfjp.mikutoga.bin.parser.BinParser;
import jp.sfjp.mikutoga.bin.parser.MmdEofException;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ProxyParser;
import jp.sfjp.mikutoga.bin.parser.TextDecoder;
import jp.sfjp.mikutoga.vmd.VmdUniq;
import jp.sfjp.mikutoga.vmd.parser.VmdBasicHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdUnifiedHandler;

class VmdBasicParser
extends ProxyParser {
    public static final Charset CS_WIN31J = Charset.forName("windows-31j");
    private static final Charset CS_ASCII = Charset.forName("US-ASCII");
    private static final int BZ_SIZE = 4;
    private static final int BZXYZR_SIZE = 16;
    private static final int BZ_REDUNDANT = 4;
    private static final int BZTOTAL_SIZE = 64;
    private static final String ERRMSG_INVINTPLT = "there is potential inconsistency in motion interpolation data. (Strict-mode)";
    private static final String ERRMSG_UK_HEADER = "unknown VMD-header type";
    private final TextDecoder decoderWin31j = new TextDecoder(CS_WIN31J);
    private final byte[] motionIntplt = new byte[64];
    private VmdBasicHandler handler = VmdUnifiedHandler.EMPTY;
    private boolean hasStageActName = false;
    private boolean redundantCheck = false;

    VmdBasicParser(BinParser parser) {
        super(parser);
        this.decoderWin31j.setZeroChopMode(true);
    }

    boolean hasStageActName() {
        return this.hasStageActName;
    }

    void setBasicHandler(VmdBasicHandler basicHandler) {
        this.handler = basicHandler == null ? VmdUnifiedHandler.EMPTY : basicHandler;
    }

    void setRedundantCheck(boolean mode) {
        this.redundantCheck = mode;
    }

    private String parseVmdText(int byteLen) throws IOException, MmdEofException, MmdFormatException {
        String result = this.parseString(this.decoderWin31j, byteLen);
        return result;
    }

    void parse() throws IOException, MmdFormatException {
        this.hasStageActName = false;
        this.parseVmdHeader();
        this.parseVmdModelName();
        this.parseVmdBoneMotion();
        this.parseVmdMorph();
    }

    private void parseVmdHeader() throws IOException, MmdFormatException {
        byte[] header = new byte[30];
        this.parseByteArray(header);
        byte[] magic = "Vocaloid Motion Data 0002\u0000".getBytes(CS_ASCII);
        for (int idx = 0; idx < magic.length; ++idx) {
            if (header.length > idx && header[idx] == magic[idx]) continue;
            throw new MmdFormatException(ERRMSG_UK_HEADER);
        }
        this.handler.vmdHeaderInfo(header);
    }

    private void parseVmdModelName() throws IOException, MmdFormatException {
        String modelName = this.parseVmdText(20);
        if (VmdUniq.isStageActName(modelName)) {
            this.hasStageActName = true;
        }
        this.handler.vmdModelName(modelName);
    }

    private void parseVmdBoneMotion() throws IOException, MmdFormatException {
        int boneMotionNo = this.parseLeInt();
        this.handler.loopStart(VmdBasicHandler.BONEMOTION_LIST, boneMotionNo);
        for (int ct = 0; ct < boneMotionNo; ++ct) {
            String boneName = this.parseVmdText(15);
            int keyFrameNo = this.parseLeInt();
            this.handler.vmdBoneMotion(boneName, keyFrameNo);
            float xPos = this.parseLeFloat();
            float yPos = this.parseLeFloat();
            float zPos = this.parseLeFloat();
            this.handler.vmdBonePosition(xPos, yPos, zPos);
            float qx = this.parseLeFloat();
            float qy = this.parseLeFloat();
            float qz = this.parseLeFloat();
            float qw = this.parseLeFloat();
            this.handler.vmdBoneRotationQt(qx, qy, qz, qw);
            this.parseVmdMotionInterpolation();
            this.handler.loopNext(VmdBasicHandler.BONEMOTION_LIST);
        }
        this.handler.loopEnd(VmdBasicHandler.BONEMOTION_LIST);
    }

    private void parseVmdMotionInterpolation() throws IOException, MmdFormatException {
        this.parseByteArray(this.motionIntplt);
        if (this.redundantCheck) {
            this.checkIntpltStrict();
        }
        int idx = 0;
        byte xP1x = this.motionIntplt[idx++];
        byte yP1x = this.motionIntplt[idx++];
        byte zP1x = this.motionIntplt[idx++];
        byte rP1x = this.motionIntplt[idx++];
        byte xP1y = this.motionIntplt[idx++];
        byte yP1y = this.motionIntplt[idx++];
        byte zP1y = this.motionIntplt[idx++];
        byte rP1y = this.motionIntplt[idx++];
        byte xP2x = this.motionIntplt[idx++];
        byte yP2x = this.motionIntplt[idx++];
        byte zP2x = this.motionIntplt[idx++];
        byte rP2x = this.motionIntplt[idx++];
        byte xP2y = this.motionIntplt[idx++];
        byte yP2y = this.motionIntplt[idx++];
        byte zP2y = this.motionIntplt[idx++];
        byte rP2y = this.motionIntplt[idx++];
        assert (idx == 16);
        this.handler.vmdBoneIntpltXpos(xP1x, xP1y, xP2x, xP2y);
        this.handler.vmdBoneIntpltYpos(yP1x, yP1y, yP2x, yP2y);
        this.handler.vmdBoneIntpltZpos(zP1x, zP1y, zP2x, zP2y);
        this.handler.vmdBoneIntpltRot(rP1x, rP1y, rP2x, rP2y);
    }

    private void checkIntpltStrict() throws MmdFormatException {
        int lack = 1;
        for (int ct = 1; ct < 4; ++ct) {
            int sourceIdx = 0 + lack;
            int targetIdx = 16 * ct;
            int span = 16 - lack;
            for (int idx = 0; idx < span; ++idx) {
                byte sourceVal = this.motionIntplt[sourceIdx + idx];
                byte targetVal = this.motionIntplt[targetIdx + idx];
                if (sourceVal == targetVal) continue;
                throw new MmdFormatException(ERRMSG_INVINTPLT, this.getPosition());
            }
            int onePos = targetIdx + span;
            if (this.motionIntplt[onePos] != 1) {
                throw new MmdFormatException(ERRMSG_INVINTPLT, this.getPosition());
            }
            int zeroPosStart = onePos + 1;
            int zeroPosEnd = targetIdx + 16;
            for (int idx = zeroPosStart; idx < zeroPosEnd; ++idx) {
                if (this.motionIntplt[idx] == 0) continue;
                throw new MmdFormatException(ERRMSG_INVINTPLT, this.getPosition());
            }
            ++lack;
        }
    }

    private void parseVmdMorph() throws IOException, MmdFormatException {
        int morphMotionNo = this.parseLeInt();
        this.handler.loopStart(VmdBasicHandler.MORPH_LIST, morphMotionNo);
        for (int ct = 0; ct < morphMotionNo; ++ct) {
            String morphName = this.parseVmdText(15);
            int keyFrameNo = this.parseLeInt();
            float flex = this.parseLeFloat();
            this.handler.vmdMorphMotion(morphName, keyFrameNo, flex);
            this.handler.loopNext(VmdBasicHandler.MORPH_LIST);
        }
        this.handler.loopEnd(VmdBasicHandler.MORPH_LIST);
    }
}

