/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd2xml;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import jp.sfjp.mikutoga.vmd2xml.CmdLine;
import jp.sfjp.mikutoga.vmd2xml.CmdLineException;
import jp.sfjp.mikutoga.vmd2xml.MotionFileType;
import jp.sfjp.mikutoga.vmd2xml.OptSwitch;
import jp.sfjp.mikutoga.vmd2xml.Vmd2Xml;

final class OptInfo {
    private static final String EOL_LF = "\n";
    private static final String EOL_CRLF = "\r\n";
    private static final String EOL_DEFAULT = "\n";
    private static final String FORMAT_VMD = "vmd";
    private static final String FORMAT_XML = "xml";
    private static final String FORMAT_XML110820 = "xml110820";
    private static final String FORMAT_XML130609 = "xml130609";
    private static final String SFX_VMD = ".vmd";
    private static final String SFX_XML = ".xml";
    private static final String NL_LF = "lf";
    private static final String NL_CRLF = "crlf";
    private static final String ERRMSG_UNKNOWN = "Unknown option : {0}";
    private static final String ERRMSG_MOREARG = "You need option arg with : {0}";
    private static final String ERRMSG_INTYPE = "You must specify input format with -iform.";
    private static final String ERRMSG_OUTTYPE = "You must specify output format with -oform.";
    private static final String ERRMSG_NOINFILE = "You must specify input file with -i.";
    private static final String ERRMSG_NOOUTFILE = "You must specify output file with -o.";
    private static final String ERRMSG_INVFORM = "Unknown format : \"{0}\" must be \"vmd\" or \"xml\" or \"xml110820\"";
    private static final String ERRMSG_INVNL = "Unknown newline : \"{0}\" must be \"lf\" or \"crlf\"";
    private static final String ERRMSG_INVBOOL = "Unknown switch : \"{0}\" must be \"on\" or \"off\"";
    private boolean needHelp = false;
    private MotionFileType inTypes = MotionFileType.NONE;
    private MotionFileType outTypes = MotionFileType.NONE;
    private String inFilename = null;
    private String outFilename = null;
    private boolean overwrite = false;
    private String newline = "\n";
    private String generator = Vmd2Xml.GENERATOR;
    private boolean isQuaternionMode = true;

    private OptInfo() {
    }

    private static MotionFileType decodeFormatType(String arg) throws CmdLineException {
        MotionFileType result;
        if (FORMAT_VMD.equals(arg)) {
            result = MotionFileType.VMD;
        } else if (FORMAT_XML.equals(arg)) {
            result = MotionFileType.XML_AUTO;
        } else if (FORMAT_XML110820.equals(arg)) {
            result = MotionFileType.XML_110820;
        } else if (FORMAT_XML130609.equals(arg)) {
            result = MotionFileType.XML_130609;
        } else {
            String errMsg = MessageFormat.format(ERRMSG_INVFORM, arg);
            throw new CmdLineException(errMsg);
        }
        return result;
    }

    private static String decodeNewline(String arg) throws CmdLineException {
        String result;
        if (NL_LF.equals(arg)) {
            result = "\n";
        } else if (NL_CRLF.equals(arg)) {
            result = EOL_CRLF;
        } else {
            String errMsg = MessageFormat.format(ERRMSG_INVNL, arg);
            throw new CmdLineException(errMsg);
        }
        return result;
    }

    private static boolean decodeBoolean(String arg) throws CmdLineException {
        boolean result;
        if ("on".equals(arg) || "true".equals(arg) || "yes".equals(arg)) {
            result = true;
        } else if ("off".equals(arg) || "false".equals(arg) || "no".equals(arg)) {
            result = false;
        } else {
            String errMsg = MessageFormat.format(ERRMSG_INVBOOL, arg);
            throw new CmdLineException(errMsg);
        }
        return result;
    }

    private static MotionFileType getFileType(String fileName) {
        MotionFileType result = MotionFileType.NONE;
        if (fileName == null) {
            return result;
        }
        String lower = fileName.toLowerCase(Locale.ROOT);
        if (lower.endsWith(SFX_VMD)) {
            result = MotionFileType.VMD;
        } else if (lower.endsWith(SFX_XML)) {
            result = MotionFileType.XML_AUTO;
        }
        return result;
    }

    private static boolean hasHelp(List<CmdLine> cmds) {
        for (CmdLine cmd : cmds) {
            OptSwitch opt = cmd.getOptSwitch();
            if (opt != OptSwitch.OPT_HELP) continue;
            return true;
        }
        return false;
    }

    private static void storeOptInfo(OptSwitch opt, String exArg, OptInfo result) throws CmdLineException {
        switch (opt) {
            case OPT_FORCE: {
                result.overwrite = true;
                break;
            }
            case OPT_QUAT: {
                result.isQuaternionMode = true;
                break;
            }
            case OPT_EYXZ: {
                result.isQuaternionMode = false;
                break;
            }
            case OPT_INFILE: {
                result.inFilename = exArg;
                break;
            }
            case OPT_OUTFILE: {
                result.outFilename = exArg;
                break;
            }
            case OPT_NEWLINE: {
                result.newline = OptInfo.decodeNewline(exArg);
                break;
            }
            case OPT_IFORM: {
                MotionFileType itype;
                result.inTypes = itype = OptInfo.decodeFormatType(exArg);
                break;
            }
            case OPT_OFORM: {
                MotionFileType otype;
                result.outTypes = otype = OptInfo.decodeFormatType(exArg);
                break;
            }
            case OPT_GENOUT: {
                boolean genout = OptInfo.decodeBoolean(exArg);
                if (genout) {
                    result.generator = Vmd2Xml.GENERATOR;
                    break;
                }
                result.generator = null;
                break;
            }
        }
    }

    static OptInfo parseOption(String ... args) throws CmdLineException {
        List<CmdLine> cmdLines = CmdLine.parse(args);
        OptInfo result = new OptInfo();
        if (OptInfo.hasHelp(cmdLines)) {
            result.needHelp = true;
            return result;
        }
        OptInfo.checkCmdLineList(cmdLines);
        for (CmdLine cmd : cmdLines) {
            OptSwitch opt = cmd.getOptSwitch();
            List<String> optArgs = cmd.getOptArgs();
            String exArg1 = null;
            if (optArgs.size() >= 2) {
                exArg1 = optArgs.get(1);
            }
            OptInfo.storeOptInfo(opt, exArg1, result);
        }
        OptInfo.fixFormat(result);
        OptInfo.checkResult(result);
        return result;
    }

    private static void checkCmdLineList(List<CmdLine> cmdLines) throws CmdLineException {
        for (CmdLine cmd : cmdLines) {
            List<String> optArgs = cmd.getOptArgs();
            assert (!optArgs.isEmpty());
            String optTxt = optArgs.get(0);
            assert (optTxt != null);
            OptSwitch opt = cmd.getOptSwitch();
            if (opt == null) {
                String errMsg = MessageFormat.format(ERRMSG_UNKNOWN, optTxt);
                throw new CmdLineException(errMsg);
            }
            int exArgNum = opt.getExArgNum();
            if (optArgs.size() == 1 + exArgNum) continue;
            String errMsg = MessageFormat.format(ERRMSG_MOREARG, optTxt);
            throw new CmdLineException(errMsg);
        }
    }

    private static void fixFormat(OptInfo result) {
        if (result.inTypes == MotionFileType.NONE) {
            result.inTypes = OptInfo.getFileType(result.inFilename);
        }
        if (result.outTypes == MotionFileType.NONE) {
            result.outTypes = OptInfo.getFileType(result.outFilename);
        }
    }

    private static void checkResult(OptInfo result) throws CmdLineException {
        if (result.getInFilename() == null) {
            throw new CmdLineException(ERRMSG_NOINFILE);
        }
        if (result.getOutFilename() == null) {
            throw new CmdLineException(ERRMSG_NOOUTFILE);
        }
        if (result.getInFileType() == MotionFileType.NONE) {
            throw new CmdLineException(ERRMSG_INTYPE);
        }
        if (result.getOutFileType() == MotionFileType.NONE) {
            throw new CmdLineException(ERRMSG_OUTTYPE);
        }
    }

    boolean needHelp() {
        return this.needHelp;
    }

    MotionFileType getInFileType() {
        return this.inTypes;
    }

    MotionFileType getOutFileType() {
        return this.outTypes;
    }

    String getInFilename() {
        return this.inFilename;
    }

    String getOutFilename() {
        return this.outFilename;
    }

    boolean overwriteMode() {
        return this.overwrite;
    }

    String getNewline() {
        return this.newline;
    }

    String getGenerator() {
        return this.generator;
    }

    boolean isQuaterniomMode() {
        return this.isQuaternionMode;
    }
}

