/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd2xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.Properties;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.vmd.IllegalVmdDataException;
import jp.sfjp.mikutoga.vmd2xml.CmdLineException;
import jp.sfjp.mikutoga.vmd2xml.OptInfo;
import jp.sfjp.mikutoga.vmd2xml.OptSwitch;
import jp.sfjp.mikutoga.vmd2xml.Vmd2XmlConv;
import jp.sfjp.mikutoga.vmd2xml.XmlInputUtil;
import jp.sfjp.mikutoga.xml.TogaXmlException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Vmd2Xml {
    public static final int EXIT_OK = 0;
    public static final int EXIT_INTERR = 1;
    public static final int EXIT_ENVERR = 2;
    public static final int EXIT_OPTERR = 3;
    public static final int EXIT_IOERR = 4;
    public static final int EXIT_XMLERR = 5;
    public static final int EXIT_VMDERR = 7;
    public static final String APPNAME;
    public static final String APPVER;
    public static final String APPLICENSE;
    public static final String APPURL;
    public static final String GENERATOR;
    private static final Class<?> THISCLASS;
    private static final String RES_VER = "resources/version.properties";
    private static final PrintStream ERROUT;
    private static final String MSG_ERR = "ERROR:\n{0}\n(-h for help)";
    private static final String MSG_HELP = "{0} {1}\n  License : {2}\n  {3}\n";
    private static final String MSG_NOINFILE = "Can''t find input file: {0}";
    private static final String MSG_ABNFILE = "{0} is not file.";
    private static final String MSG_OWOUTFILE = "{0} already exists.\nIf you want to overwrite, use -f.";
    private static final String MSG_OLDJRE = "You need JRE {0} or later.";
    private static final String REQUIRED_JRE = "1.6";

    private Vmd2Xml() {
        assert (this.getClass().equals(THISCLASS));
    }

    private static void exit(int code) {
        System.exit(code);
        assert (false);
        throw new AssertionError();
    }

    private static void errMsg(String text) {
        String msg = MessageFormat.format(MSG_ERR, text);
        ERROUT.println(msg);
    }

    private static void thPrintln(Throwable ex, boolean dumpStack) {
        if (dumpStack) {
            ex.printStackTrace(ERROUT);
        } else {
            String text = ex.toString();
            ERROUT.println(text);
        }
    }

    private static void thPrintln(Throwable ex) {
        Vmd2Xml.thPrintln(ex, false);
    }

    private static void ioError(IOException ex) {
        Vmd2Xml.thPrintln(ex);
        Vmd2Xml.exit(4);
    }

    private static void xmlError(Throwable ex) {
        Vmd2Xml.thPrintln(ex);
        Vmd2Xml.exit(5);
    }

    private static void vmdError(MmdFormatException ex) {
        Vmd2Xml.thPrintln(ex, true);
        Vmd2Xml.exit(7);
    }

    private static void internalError(Throwable ex) {
        Vmd2Xml.thPrintln(ex, true);
        Vmd2Xml.exit(1);
    }

    private static void checkJRE() {
        Package jrePackage = Object.class.getPackage();
        if (!jrePackage.isCompatibleWith(REQUIRED_JRE)) {
            String msg = MessageFormat.format(MSG_OLDJRE, REQUIRED_JRE);
            ERROUT.println(msg);
            Vmd2Xml.exit(2);
        }
    }

    private static void putHelp() {
        String msg = MessageFormat.format(MSG_HELP, APPNAME, APPVER, APPLICENSE, APPURL);
        ERROUT.println(msg);
        ERROUT.println(OptSwitch.getConsoleHelp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trunc(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.isFile()) {
            return;
        }
        if (file.length() <= 0L) {
            return;
        }
        FileOutputStream foStream = new FileOutputStream(file);
        try {
            FileChannel channnel = foStream.getChannel();
            try {
                channnel.truncate(0L);
            }
            finally {
                channnel.close();
            }
        }
        finally {
            foStream.close();
        }
    }

    private static InputSource openInfile(OptInfo optInfo) {
        String fileName = optInfo.getInFilename();
        File inFile = new File(fileName);
        if (!inFile.exists() || !inFile.isFile()) {
            String absPath = inFile.getAbsolutePath();
            String msg = MessageFormat.format(MSG_NOINFILE, absPath);
            Vmd2Xml.errMsg(msg);
            Vmd2Xml.exit(4);
        }
        InputSource source = XmlInputUtil.fileToSource(inFile);
        return source;
    }

    private static OutputStream openOutfile(OptInfo optInfo) {
        OutputStream os;
        String outputFile = optInfo.getOutFilename();
        boolean overwrite = optInfo.overwriteMode();
        File outFile = new File(outputFile);
        if (outFile.exists()) {
            String msg;
            String absPath = outFile.getAbsolutePath();
            if (!outFile.isFile()) {
                msg = MessageFormat.format(MSG_ABNFILE, absPath);
                Vmd2Xml.errMsg(msg);
                Vmd2Xml.exit(4);
            } else if (!overwrite) {
                msg = MessageFormat.format(MSG_OWOUTFILE, absPath);
                Vmd2Xml.errMsg(msg);
                Vmd2Xml.exit(4);
            }
        }
        try {
            Vmd2Xml.trunc(outFile);
        }
        catch (IOException e) {
            Vmd2Xml.ioError(e);
        }
        try {
            os = new FileOutputStream(outFile);
        }
        catch (FileNotFoundException e) {
            Vmd2Xml.ioError(e);
            assert (false);
            throw new AssertionError((Object)e);
        }
        os = new BufferedOutputStream(os);
        return os;
    }

    private static Vmd2XmlConv buildConverter(OptInfo optInfo) {
        Vmd2XmlConv converter = new Vmd2XmlConv();
        converter.setInType(optInfo.getInFileType());
        converter.setOutType(optInfo.getOutFileType());
        converter.setNewline(optInfo.getNewline());
        converter.setGenerator(optInfo.getGenerator());
        converter.setQuaterniomMode(optInfo.isQuaterniomMode());
        return converter;
    }

    private static void doConvert(Vmd2XmlConv converter, InputSource source, OutputStream ostream) {
        try {
            converter.convert(source, ostream);
        }
        catch (IOException e) {
            Vmd2Xml.ioError(e);
        }
        catch (IllegalVmdDataException e) {
            Vmd2Xml.internalError(e);
        }
        catch (MmdFormatException e) {
            Vmd2Xml.vmdError(e);
        }
        catch (TogaXmlException e) {
            Vmd2Xml.xmlError(e);
        }
        catch (SAXException e) {
            Vmd2Xml.xmlError(e);
        }
    }

    private static OptInfo parseOption(String[] args) {
        OptInfo optInfo;
        try {
            optInfo = OptInfo.parseOption(args);
        }
        catch (CmdLineException e) {
            String optErrMsg = e.getLocalizedMessage();
            Vmd2Xml.errMsg(optErrMsg);
            Vmd2Xml.exit(3);
            assert (false);
            throw new AssertionError((Object)e);
        }
        return optInfo;
    }

    public static void main(String[] args) {
        Vmd2Xml.checkJRE();
        OptInfo optInfo = Vmd2Xml.parseOption(args);
        if (optInfo.needHelp()) {
            Vmd2Xml.putHelp();
            Vmd2Xml.exit(0);
        }
        Vmd2XmlConv converter = Vmd2Xml.buildConverter(optInfo);
        InputSource source = Vmd2Xml.openInfile(optInfo);
        OutputStream ostream = Vmd2Xml.openOutfile(optInfo);
        Vmd2Xml.doConvert(converter, source, ostream);
        try {
            ostream.close();
        }
        catch (IOException e) {
            Vmd2Xml.ioError(e);
        }
        Vmd2Xml.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ERROUT = System.err;
        THISCLASS = Vmd2Xml.class;
        InputStream ver = THISCLASS.getResourceAsStream(RES_VER);
        Properties verProps = new Properties();
        try {
            try {
                verProps.load(ver);
            }
            finally {
                ver.close();
            }
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        APPNAME = verProps.getProperty("app.name");
        APPVER = verProps.getProperty("app.version");
        APPLICENSE = verProps.getProperty("app.license");
        APPURL = verProps.getProperty("app.url");
        GENERATOR = APPNAME + ' ' + APPVER;
        new Vmd2Xml().hashCode();
    }
}

