/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd2xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.vmd.IllegalVmdDataException;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.model.binio.VmdExporter;
import jp.sfjp.mikutoga.vmd.model.binio.VmdLoader;
import jp.sfjp.mikutoga.vmd.model.xml.VmdXmlExporter;
import jp.sfjp.mikutoga.vmd.model.xml.XmlMotionFileType;
import jp.sfjp.mikutoga.vmd.model.xml.XmlVmdLoader;
import jp.sfjp.mikutoga.vmd2xml.MotionFileType;
import jp.sfjp.mikutoga.vmd2xml.XmlInputUtil;
import jp.sfjp.mikutoga.xml.TogaXmlException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Vmd2XmlConv {
    private static final Charset CS_UTF8 = Charset.forName("UTF-8");
    private MotionFileType inTypes = MotionFileType.NONE;
    private MotionFileType outTypes = MotionFileType.NONE;
    private String newLine = "\r\n";
    private String generator = null;
    private boolean isQuaternionMode = true;

    public void setInType(MotionFileType type) throws IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == MotionFileType.NONE) {
            throw new IllegalArgumentException();
        }
        this.inTypes = type;
    }

    public MotionFileType getInTypes() {
        return this.inTypes;
    }

    public void setOutType(MotionFileType type) throws IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == MotionFileType.NONE) {
            throw new IllegalArgumentException();
        }
        this.outTypes = type;
    }

    public MotionFileType getOutTypes() {
        return this.outTypes;
    }

    public void setNewline(String newline) {
        this.newLine = newline;
    }

    public String getNewline() {
        return this.newLine;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setQuaterniomMode(boolean sw) {
        this.isQuaternionMode = sw;
    }

    public boolean isQuaterniomMode() {
        return this.isQuaternionMode;
    }

    public void convert(InputStream is, OutputStream os) throws IOException, MmdFormatException, SAXException, TogaXmlException, IllegalVmdDataException {
        VmdMotion motion = this.readMotion(is);
        motion.frameSort();
        this.writeMotion(motion, os);
    }

    public void convert(InputSource source, OutputStream os) throws IOException, MmdFormatException, SAXException, TogaXmlException, IllegalVmdDataException {
        VmdMotion motion = this.readMotion(source);
        motion.frameSort();
        this.writeMotion(motion, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmdMotion readMotion(InputStream is) throws IOException, MmdFormatException, SAXException, TogaXmlException {
        VmdMotion motion;
        InputSource source = new InputSource(is);
        try {
            motion = this.readMotion(source);
        }
        finally {
            is.close();
        }
        return motion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmdMotion readMotion(InputSource source) throws IOException, MmdFormatException, SAXException, TogaXmlException {
        VmdMotion motion = null;
        if (this.inTypes.isVmd()) {
            InputStream is = XmlInputUtil.openInputSource(source);
            try {
                motion = this.vmdRead(is);
            }
            finally {
                is.close();
            }
        } else if (this.inTypes.isXml()) {
            motion = this.xmlRead(source);
        } else {
            throw new IllegalStateException();
        }
        return motion;
    }

    public void writeMotion(VmdMotion motion, OutputStream os) throws IOException, IllegalVmdDataException {
        if (this.outTypes.isVmd()) {
            this.vmdOut(motion, os);
        } else if (this.outTypes.isXml()) {
            this.xmlOut(motion, os);
        } else {
            throw new IllegalStateException();
        }
    }

    private VmdMotion vmdRead(InputStream is) throws IOException, MmdFormatException {
        VmdLoader loader = new VmdLoader();
        loader.setRedundantCheck(false);
        VmdMotion motion = loader.load(is);
        return motion;
    }

    private VmdMotion xmlRead(InputSource source) throws IOException, SAXException, TogaXmlException {
        XMLReader reader = XmlInputUtil.buildReader(this.inTypes);
        XmlVmdLoader loader = new XmlVmdLoader(reader);
        VmdMotion motion = loader.parse(source);
        return motion;
    }

    private void vmdOut(VmdMotion motion, OutputStream ostream) throws IOException, IllegalVmdDataException {
        VmdExporter exporter = new VmdExporter();
        exporter.dumpVmdMotion(motion, ostream);
        ostream.close();
    }

    private void xmlOut(VmdMotion motion, OutputStream ostream) throws IOException, IllegalVmdDataException {
        VmdXmlExporter exporter = new VmdXmlExporter();
        XmlMotionFileType xmlType = this.outTypes.toXmlType();
        exporter.setXmlFileType(xmlType);
        exporter.setNewLine(this.newLine);
        exporter.setGenerator(this.generator);
        exporter.setQuaternionMode(this.isQuaternionMode);
        Writer writer = new OutputStreamWriter(ostream, CS_UTF8);
        writer = new BufferedWriter(writer);
        exporter.putVmdXml(motion, writer);
        exporter.close();
    }
}

