/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd2xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import jp.sfjp.mikutoga.vmd.model.xml.Schema110820;
import jp.sfjp.mikutoga.vmd.model.xml.Schema130609;
import jp.sfjp.mikutoga.vmd2xml.MotionFileType;
import jp.sfjp.mikutoga.xml.BotherHandler;
import jp.sfjp.mikutoga.xml.LocalXmlResource;
import jp.sfjp.mikutoga.xml.SchemaUtil;
import jp.sfjp.mikutoga.xml.XmlResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class XmlInputUtil {
    private XmlInputUtil() {
        assert (false);
        throw new AssertionError();
    }

    static InputSource fileToSource(File file) {
        URL url;
        assert (file.exists());
        URI uri = file.toURI();
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        String systemId = url.toString();
        InputSource source = new InputSource(systemId);
        return source;
    }

    static InputStream openInputSource(InputSource source) throws IllegalArgumentException, IOException {
        InputStream is = source.getByteStream();
        if (is == null) {
            String systemId = source.getSystemId();
            if (systemId == null) {
                throw new IllegalArgumentException();
            }
            URL url = new URL(systemId);
            is = url.openStream();
        }
        is = new BufferedInputStream(is);
        return is;
    }

    private static SAXParserFactory buildFactory(Schema schema) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setXIncludeAware(false);
        factory.setSchema(schema);
        return factory;
    }

    private static SAXParser buildParser(Schema schema) {
        SAXParser parser;
        SAXParserFactory factory = XmlInputUtil.buildFactory(schema);
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        catch (SAXException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        return parser;
    }

    private static Schema builsSchema(XmlResourceResolver resolver, MotionFileType xmlInType) {
        LocalXmlResource[] schemaArray;
        switch (xmlInType) {
            case XML_110820: {
                schemaArray = new LocalXmlResource[]{Schema110820.SINGLETON};
                break;
            }
            case XML_130609: {
                schemaArray = new LocalXmlResource[]{Schema130609.SINGLETON};
                break;
            }
            case XML_AUTO: {
                schemaArray = new LocalXmlResource[]{Schema110820.SINGLETON, Schema130609.SINGLETON};
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Schema schema = SchemaUtil.newSchema(resolver, schemaArray);
        return schema;
    }

    static XMLReader buildReader(MotionFileType xmlInType) {
        XMLReader reader;
        XmlResourceResolver resolver = new XmlResourceResolver();
        Schema schema = XmlInputUtil.builsSchema(resolver, xmlInType);
        SAXParser parser = XmlInputUtil.buildParser(schema);
        try {
            reader = parser.getXMLReader();
        }
        catch (SAXException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        reader.setEntityResolver(resolver);
        reader.setErrorHandler(BotherHandler.HANDLER);
        return reader;
    }
}

