/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.model;

import jp.sfjp.mikutoga.pmd.model.SerialNumbered;
import jp.sourceforge.mikutoga.corelib.I18nText;
import jp.sourceforge.mikutoga.math.MkPos3D;
import jp.sourceforge.mikutoga.pmd.BoneType;

public class BoneInfo
implements SerialNumbered {
    private final I18nText boneName = new I18nText();
    private BoneType boneType;
    private BoneInfo prevBone;
    private BoneInfo nextBone;
    private BoneInfo srcBone;
    private final MkPos3D position = new MkPos3D();
    private int rotationRatio;
    private int serialNo = -1;

    public I18nText getBoneName() {
        return this.boneName;
    }

    public void setBoneType(BoneType type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException();
        }
        this.boneType = type;
    }

    public BoneType getBoneType() {
        return this.boneType;
    }

    public void setPrevBone(BoneInfo prevBone) {
        this.prevBone = prevBone;
    }

    public BoneInfo getPrevBone() {
        return this.prevBone;
    }

    public void setNextBone(BoneInfo nextBone) {
        this.nextBone = nextBone;
    }

    public BoneInfo getNextBone() {
        return this.nextBone;
    }

    public void setSrcBone(BoneInfo ikBoneArg) {
        this.srcBone = ikBoneArg;
    }

    public BoneInfo getSrcBone() {
        return this.srcBone;
    }

    public MkPos3D getPosition() {
        return this.position;
    }

    public int getRotationRatio() {
        return this.rotationRatio;
    }

    public void setRotationRatio(int ratio) {
        this.rotationRatio = ratio;
    }

    @Override
    public void setSerialNumber(int num) {
        this.serialNo = num;
    }

    @Override
    public int getSerialNumber() {
        return this.serialNo;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Bone").append(this.serialNo).append("(").append(this.boneName.getPrimaryText()).append(")");
        result.append(" type=").append((Object)this.boneType);
        result.append(" prev=");
        if (this.prevBone != null) {
            result.append(this.prevBone.getBoneName());
        } else {
            result.append("NONE");
        }
        result.append(" next=");
        if (this.nextBone != null) {
            result.append(this.nextBone.getBoneName());
        } else {
            result.append("NONE");
        }
        if (this.boneType == BoneType.LINKEDROT) {
            result.append(" rotraio=").append(this.rotationRatio);
        } else {
            result.append(" ik=");
            if (this.srcBone != null) {
                result.append(this.srcBone.getBoneName());
            } else {
                result.append("NONE");
            }
        }
        result.append(" ").append(this.position);
        return result.toString();
    }
}

