/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.model;

import java.util.ArrayList;
import java.util.Iterator;
import jp.sfjp.mikutoga.pmd.model.SerialNumbered;
import jp.sfjp.mikutoga.pmd.model.Vertex;

public class Surface
implements SerialNumbered,
Iterable<Vertex> {
    private Vertex vertex1;
    private Vertex vertex2;
    private Vertex vertex3;
    private int serialNo = -1;

    public void setTriangle(Vertex vertex1, Vertex vertex2, Vertex vertex3) throws IllegalArgumentException {
        if (vertex1 != null && (vertex1 == vertex2 || vertex1 == vertex3)) {
            throw new IllegalArgumentException();
        }
        if (vertex2 != null && vertex2 == vertex3) {
            throw new IllegalArgumentException();
        }
        this.vertex1 = vertex1;
        this.vertex2 = vertex2;
        this.vertex3 = vertex3;
    }

    public Vertex[] getTriangle(Vertex[] store) {
        Vertex[] result = store == null || store.length < 3 ? new Vertex[3] : store;
        result[0] = this.vertex1;
        result[1] = this.vertex2;
        result[2] = this.vertex3;
        return result;
    }

    public Vertex getVertex1() {
        return this.vertex1;
    }

    public Vertex getVertex2() {
        return this.vertex2;
    }

    public Vertex getVertex3() {
        return this.vertex3;
    }

    @Override
    public Iterator<Vertex> iterator() {
        ArrayList<Vertex> list = new ArrayList<Vertex>(3);
        list.add(this.vertex1);
        list.add(this.vertex2);
        list.add(this.vertex3);
        return list.iterator();
    }

    public boolean isCompleted() {
        return this.vertex1 != null && this.vertex2 != null && this.vertex3 != null;
    }

    @Override
    public void setSerialNumber(int num) {
        this.serialNo = num;
    }

    @Override
    public int getSerialNumber() {
        return this.serialNo;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Surface(").append(this.getSerialNumber()).append(")");
        if (this.isCompleted()) {
            result.append(" VID=[").append(this.vertex1.getSerialNumber()).append(',').append(this.vertex2.getSerialNumber()).append(',').append(this.vertex3.getSerialNumber()).append(']');
        }
        return result.toString();
    }
}

