/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.xml;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import jp.sfjp.mikutoga.pmd.model.BoneGroup;
import jp.sfjp.mikutoga.pmd.model.BoneInfo;
import jp.sfjp.mikutoga.pmd.model.DynamicsInfo;
import jp.sfjp.mikutoga.pmd.model.IKChain;
import jp.sfjp.mikutoga.pmd.model.JointInfo;
import jp.sfjp.mikutoga.pmd.model.Material;
import jp.sfjp.mikutoga.pmd.model.MorphPart;
import jp.sfjp.mikutoga.pmd.model.MorphVertex;
import jp.sfjp.mikutoga.pmd.model.PmdModel;
import jp.sfjp.mikutoga.pmd.model.RigidGroup;
import jp.sfjp.mikutoga.pmd.model.RigidInfo;
import jp.sfjp.mikutoga.pmd.model.RigidShape;
import jp.sfjp.mikutoga.pmd.model.SerialNumbered;
import jp.sfjp.mikutoga.pmd.model.ShadeInfo;
import jp.sfjp.mikutoga.pmd.model.Surface;
import jp.sfjp.mikutoga.pmd.model.ToonMap;
import jp.sfjp.mikutoga.pmd.model.Vertex;
import jp.sfjp.mikutoga.pmd.xml.XmlModelFileType;
import jp.sourceforge.mikutoga.corelib.I18nText;
import jp.sourceforge.mikutoga.math.MkPos2D;
import jp.sourceforge.mikutoga.math.MkPos3D;
import jp.sourceforge.mikutoga.math.MkVec3D;
import jp.sourceforge.mikutoga.pmd.BoneType;
import jp.sourceforge.mikutoga.pmd.Deg3d;
import jp.sourceforge.mikutoga.pmd.MorphType;
import jp.sourceforge.mikutoga.pmd.Rad3d;
import jp.sourceforge.mikutoga.pmd.RigidShapeType;
import jp.sourceforge.mikutoga.pmd.TripletRange;
import jp.sourceforge.mikutoga.xml.BasicXmlExporter;

public class XmlExporter
extends BasicXmlExporter {
    private static final String TOP_COMMENT = "  MikuMikuDance\n    model-data(*.pmd) on XML";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    private static final String PFX_SURFACEGROUP = "sg";
    private static final String PFX_TOONFILE = "tf";
    private static final String PFX_VERTEX = "vtx";
    private static final String PFX_BONE = "bn";
    private static final String PFX_RIGID = "rd";
    private static final String PFX_RIGIDGROUP = "rg";
    private static final String BONETYPE_COMMENT = "Bone types:\n[0 : ROTATE      : Rotate       : \u56de\u8ee2           :]\n[1 : ROTMOV      : Rotate/Move  : \u56de\u8ee2/\u79fb\u52d5      :]\n[2 : IK          : IK           : IK             :]\n[3 : UNKNOWN     : Unknown      : \u4e0d\u660e           :]\n[4 : UNDERIK     : Under IK     : IK\u5f71\u97ff\u4e0b(\u56de\u8ee2) :]\n[5 : UNDERROT    : Under rotate : \u56de\u8ee2\u5f71\u97ff\u4e0b     :]\n[6 : IKCONNECTED : IK connected : IK\u63a5\u7d9a\u5148       :]\n[7 : HIDDEN      : Hidden       : \u975e\u8868\u793a         :]\n[8 : TWIST       : Twist        : \u6369\u308a           :]\n[9 : LINKEDROT   : Linked Rotate: \u56de\u8ee2\u9023\u52d5       :]\n";
    private static final String MORPHTYPE_COMMENT = "Morph types:\n[1 : EYEBROW : \u307e\u3086   ]\n[2 : EYE     : \u76ee     ]\n[3 : LIP     : \u30ea\u30c3\u30d7 ]\n[4 : EXTRA   : \u305d\u306e\u4ed6 ]\n";
    private static final String RIGIDBEHAVIOR_COMMENT = "Rigid behavior types:\n[0 : FOLLOWBONE    : \u30dc\u30fc\u30f3\u8ffd\u5f93       ]\n[1 : ONLYDYNAMICS  : \u7269\u7406\u6f14\u7b97         ]\n[2 : BONEDDYNAMICS : \u30dc\u30fc\u30f3\u4f4d\u7f6e\u5408\u308f\u305b ]\n";
    private String generator = null;
    private XmlModelFileType xmlType = XmlModelFileType.XML_101009;

    public XmlExporter(OutputStream stream) {
        super(stream);
    }

    public XmlModelFileType getXmlFileType() {
        return this.xmlType;
    }

    public void setXmlFileType(XmlModelFileType type) {
        switch (type) {
            case XML_101009: 
            case XML_130128: {
                this.xmlType = type;
                break;
            }
            case XML_AUTO: {
                this.xmlType = XmlModelFileType.XML_130128;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        assert (this.xmlType == XmlModelFileType.XML_101009 || this.xmlType == XmlModelFileType.XML_130128);
    }

    public void setGenerator(String generatorArg) {
        this.generator = generatorArg;
    }

    public static boolean hasOnlyBasicLatin(CharSequence seq) {
        if (seq == null) {
            return true;
        }
        int length = seq.length();
        for (int pos = 0; pos < length; ++pos) {
            char ch = seq.charAt(pos);
            if (ch <= '\u007f') continue;
            return false;
        }
        return true;
    }

    @Override
    public XmlExporter ind() throws IOException {
        super.ind();
        return this;
    }

    protected XmlExporter putUnescapedComment(CharSequence seq) throws IOException {
        if (!this.isBasicLatinOnlyOut()) {
            return this;
        }
        if (XmlExporter.hasOnlyBasicLatin(seq)) {
            return this;
        }
        this.sp().putLineComment(seq);
        return this;
    }

    protected XmlExporter putI18nName(I18nText text) throws IOException {
        for (String lang639 : text.lang639CodeList()) {
            if (lang639.equals(I18nText.CODE639_PRIMARY)) continue;
            String name = text.getI18nText(lang639);
            this.ind().putRawText("<i18nName ");
            this.putAttr("lang", lang639).sp();
            this.putAttr("name", name);
            this.putRawText(" />");
            this.putUnescapedComment(name);
            this.ln();
        }
        return this;
    }

    protected XmlExporter putNumberedIdAttr(CharSequence attrName, CharSequence prefix, int num) throws IOException {
        this.putRawText(attrName).putRawText("=\"");
        this.putRawText(prefix).putXsdInt(num);
        this.putRawCh('\"');
        return this;
    }

    protected XmlExporter putNumberedIdAttr(CharSequence attrName, CharSequence prefix, SerialNumbered numbered) throws IOException {
        this.putNumberedIdAttr(attrName, prefix, numbered.getSerialNumber());
        return this;
    }

    protected XmlExporter putPosition(MkPos3D position) throws IOException {
        this.putRawText("<position ");
        this.putFloatAttr("x", (float)position.getXpos()).sp();
        this.putFloatAttr("y", (float)position.getYpos()).sp();
        this.putFloatAttr("z", (float)position.getZpos()).sp();
        this.putRawText("/>");
        return this;
    }

    protected XmlExporter putRadRotation(Rad3d rotation) throws IOException {
        this.putRawText("<radRotation ");
        this.putFloatAttr("xRad", rotation.getXRad()).sp();
        this.putFloatAttr("yRad", rotation.getYRad()).sp();
        this.putFloatAttr("zRad", rotation.getZRad()).sp();
        this.putRawText("/>");
        return this;
    }

    protected XmlExporter putLocalNameComment(I18nText name) throws IOException {
        String localName = name.getText();
        if (localName.isEmpty()) {
            localName = "[NAMELESS]";
        }
        this.ind().putLineComment(localName);
        return this;
    }

    protected XmlExporter putPrimaryNameAttr(CharSequence attrName, I18nText name) throws IOException {
        String primaryName = name.getPrimaryText();
        this.putAttr(attrName, primaryName);
        return this;
    }

    public void putPmdModel(PmdModel model) throws IOException {
        String version;
        String xsduri;
        String defns;
        this.ind().putRawText("<?xml").sp().putAttr("version", "1.0").sp().putAttr("encoding", "UTF-8").sp().putRawText("?>").ln(2);
        this.ind().putBlockComment(TOP_COMMENT).ln(2);
        I18nText modelName = model.getModelName();
        this.ind().putLocalNameComment(modelName).ln();
        this.ind().putRawText("<pmdModel").ln();
        this.pushNest();
        if (this.xmlType == XmlModelFileType.XML_101009) {
            defns = "http://mikutoga.sourceforge.jp/xml/ns/pmdxml/101009";
            xsduri = "http://mikutoga.sourceforge.jp/xml/xsd/pmdxml-101009.xsd";
            version = "101009";
        } else if (this.xmlType == XmlModelFileType.XML_130128) {
            defns = "http://mikutoga.sourceforge.jp/xml/ns/pmdxml/130128";
            xsduri = "http://mikutoga.sourceforge.jp/xml/xsd/pmdxml-130128.xsd";
            version = "130128";
        } else {
            assert (false);
            throw new AssertionError();
        }
        this.ind().putAttr("xmlns", defns).ln();
        this.ind().putAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").ln();
        this.ind().putRawText("xsi:schemaLocation").putRawText("=\"");
        this.putRawText(defns).ln();
        this.pushNest();
        this.ind().putRawText(xsduri).putRawCh('\"').ln();
        this.popNest();
        this.ind().putAttr("schemaVersion", version).ln(2);
        this.ind().putPrimaryNameAttr("name", modelName).ln();
        this.popNest();
        this.putRawText(">").ln(2);
        this.putModelInfo(model).flush();
        this.putMetaInfo(model).flush();
        this.putMaterialList(model).flush();
        this.putToonMap(model).flush();
        this.putBoneList(model).flush();
        this.putBoneGroupList(model).flush();
        this.putIKChainList(model).flush();
        this.putMorphList(model).flush();
        this.putRigidList(model).flush();
        this.putRigidGroupList(model).flush();
        this.putJointList(model).flush();
        this.putSurfaceGroupList(model).flush();
        this.putVertexList(model).flush();
        this.ind().putRawText("</pmdModel>").ln(2);
        this.ind().putRawText("<!-- EOF -->").ln();
    }

    private XmlExporter putModelInfo(PmdModel model) throws IOException {
        I18nText modelName = model.getModelName();
        this.putI18nName(modelName);
        this.ln();
        I18nText description = model.getDescription();
        for (String lang639 : description.lang639CodeList()) {
            String descText = description.getI18nText(lang639);
            this.putDescription(lang639, descText);
            this.ln();
        }
        return this;
    }

    private XmlExporter putDescription(CharSequence lang639, CharSequence content) throws IOException {
        String text = ((Object)content).toString();
        text = text.replace(CRLF, LF);
        text = text.replace(CR, LF);
        this.ind().putRawText("<description");
        if (!I18nText.CODE639_PRIMARY.equals(lang639)) {
            this.sp().putAttr("lang", lang639).sp();
        }
        this.putRawText(">").ln();
        this.putBRedContent(text);
        this.ind().putRawText("</description>").ln();
        if (!XmlExporter.hasOnlyBasicLatin(text) && this.isBasicLatinOnlyOut()) {
            this.putBlockComment(text);
        }
        return this;
    }

    protected BasicXmlExporter putBRedContent(CharSequence content) throws IOException {
        int length = content.length();
        int startPos = 0;
        for (int idx = 0; idx < length; ++idx) {
            char ch = content.charAt(idx);
            if (ch != '\n') continue;
            CharSequence seq = content.subSequence(startPos, idx);
            this.putContent(seq).putRawText("<br/>").ln();
            startPos = idx + 1;
        }
        if (startPos < length) {
            CharSequence seq = content.subSequence(startPos, length);
            this.putContent(seq).ln();
        }
        return this;
    }

    private XmlExporter putMetaInfo(PmdModel model) throws IOException {
        this.ind().putRawText("<license>").ln();
        this.ind().putRawText("</license>").ln(2);
        this.ind().putRawText("<credits>").ln();
        this.ind().putRawText("</credits>").ln(2);
        if (this.generator != null) {
            this.ind().putRawText("<meta ");
            this.putAttr("name", "generator").sp().putAttr("content", this.generator);
            this.putRawText(" />").ln();
        }
        this.ind().putRawText("<meta ");
        this.putAttr("name", "siteURL").sp().putAttr("content", "");
        this.putRawText(" />").ln();
        this.ind().putRawText("<meta ");
        this.putAttr("name", "imageURL").sp().putAttr("content", "");
        this.putRawText(" />").ln(2);
        return this;
    }

    private XmlExporter putMaterialList(PmdModel model) throws IOException {
        this.ind().putRawText("<materialList>").ln();
        this.pushNest();
        int ct = 0;
        boolean dumped = false;
        List<Material> materialList = model.getMaterialList();
        for (Material material : materialList) {
            if (!dumped) {
                this.ln();
            }
            this.putMaterial(material, ct++);
            dumped = true;
        }
        this.popNest();
        this.ind().putRawText("</materialList>").ln(2);
        return this;
    }

    private XmlExporter putMaterial(Material material, int no) throws IOException {
        String bool = material.getEdgeAppearance() ? "true" : "false";
        I18nText name = material.getMaterialName();
        String primary = name.getPrimaryText();
        String local = name.getText();
        if (local != null && local.length() > 0) {
            this.ind().putLineComment(local).ln();
        }
        this.ind().putRawText("<material ");
        if (primary != null && primary.length() > 0) {
            this.putAttr("name", primary).sp();
        }
        this.putAttr("showEdge", bool);
        this.sp();
        this.putNumberedIdAttr((CharSequence)"surfaceGroupIdRef", (CharSequence)PFX_SURFACEGROUP, no);
        this.sp().putRawCh('>').ln();
        this.pushNest();
        this.putI18nName(name);
        float[] rgba = new float[4];
        Color diffuse = material.getDiffuseColor();
        diffuse.getRGBComponents(rgba);
        this.ind().putRawText("<diffuse ");
        this.putFloatAttr("r", rgba[0]).sp();
        this.putFloatAttr("g", rgba[1]).sp();
        this.putFloatAttr("b", rgba[2]).sp();
        this.putFloatAttr("alpha", rgba[3]).sp();
        this.putRawText("/>").ln();
        Color specular = material.getSpecularColor();
        specular.getRGBComponents(rgba);
        float shininess = material.getShininess();
        this.ind().putRawText("<specular ");
        this.putFloatAttr("r", rgba[0]).sp();
        this.putFloatAttr("g", rgba[1]).sp();
        this.putFloatAttr("b", rgba[2]).sp();
        this.putFloatAttr("shininess", shininess).sp();
        this.putRawText("/>").ln();
        Color ambient = material.getAmbientColor();
        ambient.getRGBComponents(rgba);
        this.ind().putRawText("<ambient ");
        this.putFloatAttr("r", rgba[0]).sp();
        this.putFloatAttr("g", rgba[1]).sp();
        this.putFloatAttr("b", rgba[2]).sp();
        this.putRawText("/>").ln();
        ShadeInfo shade = material.getShadeInfo();
        String textureFileName = shade.getTextureFileName();
        String spheremapFileName = shade.getSpheremapFileName();
        if (shade.isValidToonIndex()) {
            this.ind().putRawText("<toon ");
            int toonIdx = shade.getToonIndex();
            this.putNumberedIdAttr((CharSequence)"toonFileIdRef", (CharSequence)PFX_TOONFILE, toonIdx);
            this.putRawText(" />");
            String toonFileName = shade.getToonFileName();
            if (toonFileName != null && toonFileName.length() > 0) {
                this.sp().putLineComment(toonFileName);
            }
            this.ln();
        }
        if (textureFileName != null && textureFileName.length() > 0) {
            this.ind().putRawText("<textureFile ");
            this.putAttr("winFileName", textureFileName);
            this.putRawText(" />").ln();
        }
        if (spheremapFileName != null && spheremapFileName.length() > 0) {
            this.ind().putRawText("<spheremapFile ");
            this.putAttr("winFileName", spheremapFileName);
            this.putRawText(" />").ln();
        }
        this.popNest();
        this.ind().putRawText("</material>").ln(2);
        return this;
    }

    private XmlExporter putToonMap(PmdModel model) throws IOException {
        this.ind().putRawText("<toonMap>").ln();
        this.pushNest();
        ToonMap map = model.getToonMap();
        for (int index = 0; index <= 9; ++index) {
            this.ind().putToon(map, index).ln();
        }
        this.popNest();
        this.ind().putRawText("</toonMap>").ln(2);
        return this;
    }

    private XmlExporter putToon(ToonMap map, int index) throws IOException {
        this.putRawText("<toonDef ");
        this.putNumberedIdAttr((CharSequence)"toonFileId", (CharSequence)PFX_TOONFILE, index).sp();
        this.putIntAttr("index", index).sp();
        String toonFile = map.getIndexedToon(index);
        this.putAttr("winFileName", toonFile);
        this.putRawText(" />");
        this.putUnescapedComment(toonFile);
        return this;
    }

    private XmlExporter putSurfaceGroupList(PmdModel model) throws IOException {
        this.ind().putRawText("<surfaceGroupList>").ln();
        this.pushNest();
        int ct = 0;
        boolean dumped = false;
        List<Material> materialList = model.getMaterialList();
        for (Material material : materialList) {
            List<Surface> surfaceList = material.getSurfaceList();
            if (!dumped) {
                this.ln();
            }
            this.putSurfaceList(surfaceList, ct++);
            dumped = true;
        }
        this.popNest();
        this.ind().putRawText("</surfaceGroupList>").ln(2);
        return this;
    }

    private XmlExporter putSurfaceList(List<Surface> surfaceList, int index) throws IOException {
        this.ind().putRawText("<surfaceGroup ");
        this.putNumberedIdAttr((CharSequence)"surfaceGroupId", (CharSequence)PFX_SURFACEGROUP, index);
        this.sp().putRawText(">").ln();
        this.pushNest();
        for (Surface surface : surfaceList) {
            this.putSurface(surface);
        }
        this.popNest();
        this.ind().putRawText("</surfaceGroup>").ln(2);
        return this;
    }

    private XmlExporter putSurface(Surface surface) throws IOException {
        this.ind().putRawText("<surface ");
        Vertex vertex1 = surface.getVertex1();
        Vertex vertex2 = surface.getVertex2();
        Vertex vertex3 = surface.getVertex3();
        this.putNumberedIdAttr((CharSequence)"vtxIdRef1", (CharSequence)PFX_VERTEX, vertex1).sp();
        this.putNumberedIdAttr((CharSequence)"vtxIdRef2", (CharSequence)PFX_VERTEX, vertex2).sp();
        this.putNumberedIdAttr((CharSequence)"vtxIdRef3", (CharSequence)PFX_VERTEX, vertex3).sp();
        this.putRawText("/>").ln();
        return this;
    }

    private XmlExporter putVertexList(PmdModel model) throws IOException {
        this.ind().putRawText("<vertexList>").ln();
        this.pushNest();
        boolean dumped = false;
        List<Vertex> vertexList = model.getVertexList();
        for (Vertex vertex : vertexList) {
            if (!dumped) {
                this.ln();
            }
            this.putVertex(vertex);
            dumped = true;
        }
        this.popNest();
        this.ind().putRawText("</vertexList>").ln(2);
        return this;
    }

    private XmlExporter putVertex(Vertex vertex) throws IOException {
        String bool = vertex.getEdgeAppearance() ? "true" : "false";
        this.ind().putRawText("<vertex ");
        this.putNumberedIdAttr((CharSequence)"vtxId", (CharSequence)PFX_VERTEX, vertex).sp();
        this.putAttr("showEdge", bool);
        this.sp().putRawText(">").ln();
        this.pushNest();
        MkPos3D position = vertex.getPosition();
        this.ind().putPosition(position).ln();
        MkVec3D normal = vertex.getNormal();
        this.ind().putRawText("<normal ");
        this.putFloatAttr("x", (float)normal.getXVal()).sp();
        this.putFloatAttr("y", (float)normal.getYVal()).sp();
        this.putFloatAttr("z", (float)normal.getZVal()).sp();
        this.putRawText("/>").ln();
        MkPos2D uvPos = vertex.getUVPosition();
        this.ind().putRawText("<uvMap ");
        this.putFloatAttr("u", (float)uvPos.getXpos()).sp();
        this.putFloatAttr("v", (float)uvPos.getYpos()).sp();
        this.putRawText("/>").ln();
        BoneInfo boneA = vertex.getBoneA();
        BoneInfo boneB = vertex.getBoneB();
        int weight = vertex.getWeightA();
        this.ind().putRawText("<skinning ");
        this.putNumberedIdAttr((CharSequence)"boneIdRef1", (CharSequence)PFX_BONE, boneA).sp();
        this.putNumberedIdAttr((CharSequence)"boneIdRef2", (CharSequence)PFX_BONE, boneB).sp();
        this.putIntAttr("weightBalance", weight).sp();
        this.putRawText("/>").ln();
        this.popNest();
        this.ind().putRawText("</vertex>").ln(2);
        return this;
    }

    private XmlExporter putBoneList(PmdModel model) throws IOException {
        this.ind().putRawText("<boneList>").ln();
        this.pushNest();
        boolean dumped = false;
        for (BoneInfo bone : model.getBoneList()) {
            if (!dumped) {
                this.ln().putBlockComment(BONETYPE_COMMENT).ln();
            }
            this.putBone(bone);
            dumped = true;
        }
        this.popNest();
        this.ind().putRawText("</boneList>").ln(2);
        return this;
    }

    private XmlExporter putBone(BoneInfo bone) throws IOException {
        I18nText i18nName = bone.getBoneName();
        BoneType type = bone.getBoneType();
        StringBuilder boneComment = new StringBuilder();
        String boneName = i18nName.getText();
        if (boneName.isEmpty()) {
            boneName = "[NAMELESS]";
        }
        boneComment.append(boneName);
        String typeName = type.getGuiName();
        boneComment.append(" [").append(typeName).append(']');
        this.ind().putLineComment(boneComment.toString()).ln();
        this.ind().putRawText("<bone ");
        this.putPrimaryNameAttr("name", i18nName).sp();
        this.putNumberedIdAttr((CharSequence)"boneId", (CharSequence)PFX_BONE, bone).sp();
        this.putAttr("type", type.name());
        this.sp().putRawText(">").ln();
        this.pushNest();
        this.putI18nName(i18nName);
        MkPos3D position = bone.getPosition();
        this.ind().putPosition(position).ln();
        BoneInfo srcBone = bone.getSrcBone();
        if (bone.getBoneType() == BoneType.LINKEDROT) {
            this.ind().putRawText("<rotationRatio ");
            this.putIntAttr("ratio", bone.getRotationRatio());
            this.putRawText(" />").ln();
        } else if (srcBone != null) {
            String iktag;
            switch (this.getXmlFileType()) {
                case XML_101009: {
                    iktag = "<ikBone ";
                    break;
                }
                case XML_130128: {
                    iktag = "<sourceBone ";
                    break;
                }
                default: {
                    assert (false);
                    throw new AssertionError();
                }
            }
            this.ind().putRawText(iktag);
            this.putNumberedIdAttr((CharSequence)"boneIdRef", (CharSequence)PFX_BONE, srcBone);
            this.putRawText(" /> ");
            String ikBoneName = "Ref:" + srcBone.getBoneName().getText();
            this.putLineComment(ikBoneName);
            this.ln();
        }
        BoneInfo prev = bone.getPrevBone();
        BoneInfo next = bone.getNextBone();
        StringBuilder chainComment = new StringBuilder();
        if (prev != null) {
            chainComment.append('[').append(prev.getBoneName().getPrimaryText()).append(']').append(" >>#");
        }
        if (next != null) {
            if (chainComment.length() <= 0) {
                chainComment.append("#");
            }
            chainComment.append(">> ").append('[').append(next.getBoneName().getPrimaryText()).append(']');
        }
        if (chainComment.length() > 0) {
            this.ln();
            this.ind().putLineComment(chainComment).ln();
        }
        this.ind().putRawText("<boneChain");
        if (prev != null) {
            this.sp();
            this.putNumberedIdAttr((CharSequence)"prevBoneIdRef", (CharSequence)PFX_BONE, prev);
        }
        if (next != null) {
            this.sp();
            this.putNumberedIdAttr((CharSequence)"nextBoneIdRef", (CharSequence)PFX_BONE, next);
        }
        this.putRawText(" />").ln();
        this.popNest();
        this.ind().putRawText("</bone>").ln(2);
        return this;
    }

    private XmlExporter putBoneGroupList(PmdModel model) throws IOException {
        this.ind().putRawText("<boneGroupList>").ln();
        this.pushNest();
        boolean dumped = false;
        List<BoneGroup> groupList = model.getBoneGroupList();
        for (BoneGroup group : groupList) {
            if (group.isDefaultBoneGroup()) continue;
            if (!dumped) {
                this.ln();
            }
            this.putBoneGroup(group);
            dumped = true;
        }
        this.popNest();
        this.ind().putRawText("</boneGroupList>").ln(2);
        return this;
    }

    private XmlExporter putBoneGroup(BoneGroup group) throws IOException {
        I18nText i18nName = group.getGroupName();
        this.putLocalNameComment(i18nName).ln();
        this.ind().putRawText("<boneGroup ");
        this.putPrimaryNameAttr("name", i18nName);
        this.sp().putRawText(">").ln();
        this.pushNest();
        this.putI18nName(i18nName);
        for (BoneInfo bone : group) {
            this.ind().putRawText("<boneGroupMember ");
            this.putNumberedIdAttr((CharSequence)"boneIdRef", (CharSequence)PFX_BONE, bone);
            this.putRawText(" /> ");
            String boneName = "Ref:" + bone.getBoneName().getText();
            this.putLineComment(boneName).ln();
        }
        this.popNest();
        this.ind().putRawText("</boneGroup>").ln(2);
        return this;
    }

    private XmlExporter putIKChainList(PmdModel model) throws IOException {
        this.ind().putRawText("<ikChainList>").ln();
        this.pushNest();
        boolean dumped = false;
        List<IKChain> chainList = model.getIKChainList();
        for (IKChain chain : chainList) {
            if (!dumped) {
                this.ln();
            }
            this.putIKChain(chain);
            dumped = true;
        }
        this.popNest();
        this.ind().putRawText("</ikChainList>").ln(2);
        return this;
    }

    private XmlExporter putIKChain(IKChain chain) throws IOException {
        int depth = chain.getIKDepth();
        float weight = chain.getIKWeight();
        BoneInfo ikBone = chain.getIkBone();
        this.ind().putLineComment("Ref:" + ikBone.getBoneName().getText()).ln();
        this.ind().putRawText("<ikChain ");
        this.putNumberedIdAttr((CharSequence)"ikBoneIdRef", (CharSequence)PFX_BONE, ikBone).sp();
        this.putIntAttr("recursiveDepth", depth).sp();
        this.putFloatAttr("weight", weight);
        this.sp().putRawText(">").ln();
        this.pushNest();
        for (BoneInfo bone : chain) {
            this.ind().putRawText("<chainOrder ");
            this.putNumberedIdAttr((CharSequence)"boneIdRef", (CharSequence)PFX_BONE, bone);
            this.putRawText(" /> ");
            this.putLineComment("Ref:" + bone.getBoneName().getText());
            this.ln();
        }
        this.popNest();
        this.ind().putRawText("</ikChain>").ln(2);
        return this;
    }

    private XmlExporter putMorphList(PmdModel model) throws IOException {
        this.ind().putRawText("<morphList>").ln();
        this.pushNest();
        boolean dumped = false;
        Map<MorphType, List<MorphPart>> morphMap = model.getMorphMap();
        for (MorphType type : MorphType.values()) {
            List<MorphPart> partList;
            if (type == MorphType.BASE || (partList = morphMap.get((Object)type)) == null) continue;
            for (MorphPart part : partList) {
                if (!dumped) {
                    this.ln().putBlockComment(MORPHTYPE_COMMENT).ln();
                }
                this.putMorphPart(part);
                dumped = true;
            }
        }
        this.popNest();
        this.ind().putRawText("</morphList>").ln(2);
        return this;
    }

    private XmlExporter putMorphPart(MorphPart part) throws IOException {
        I18nText i18nName = part.getMorphName();
        String primary = i18nName.getPrimaryText();
        this.putLocalNameComment(i18nName).ln();
        this.ind().putRawText("<morph ");
        this.putAttr("name", primary).sp();
        this.putAttr("type", part.getMorphType().name());
        this.sp().putRawText(">");
        this.ln();
        this.pushNest();
        this.putI18nName(i18nName);
        for (MorphVertex mvertex : part) {
            MkPos3D offset = mvertex.getOffset();
            Vertex base = mvertex.getBaseVertex();
            this.ind().putRawText("<morphVertex ");
            this.putNumberedIdAttr((CharSequence)"vtxIdRef", (CharSequence)PFX_VERTEX, base).sp();
            this.putFloatAttr("xOff", (float)offset.getXpos()).sp();
            this.putFloatAttr("yOff", (float)offset.getYpos()).sp();
            this.putFloatAttr("zOff", (float)offset.getZpos()).sp();
            this.putRawText("/>");
            this.ln();
        }
        this.popNest();
        this.ind().putRawText("</morph>").ln(2);
        return this;
    }

    private XmlExporter putRigidList(PmdModel model) throws IOException {
        this.ind().putRawText("<rigidList>").ln();
        this.pushNest();
        boolean dumped = false;
        for (RigidInfo rigid : model.getRigidList()) {
            if (!dumped) {
                this.ln().putBlockComment(RIGIDBEHAVIOR_COMMENT).ln();
            }
            this.putRigid(rigid);
            dumped = true;
        }
        this.popNest();
        this.ind().putRawText("</rigidList>").ln(2);
        return this;
    }

    private XmlExporter putRigid(RigidInfo rigid) throws IOException {
        BoneInfo linkedBone = rigid.getLinkedBone();
        I18nText i18nName = rigid.getRigidName();
        String primary = i18nName.getPrimaryText();
        this.putLocalNameComment(i18nName).ln();
        this.ind().putRawText("<rigid ");
        this.putAttr("name", primary).sp();
        this.putNumberedIdAttr((CharSequence)"rigidId", (CharSequence)PFX_RIGID, rigid).sp();
        this.putAttr("behavior", rigid.getBehaviorType().name());
        this.sp().putRawText(">").ln();
        this.pushNest();
        this.putI18nName(i18nName);
        if (linkedBone != null) {
            this.ind().putRawText("<linkedBone ");
            this.putNumberedIdAttr((CharSequence)"boneIdRef", (CharSequence)PFX_BONE, linkedBone);
            this.putRawText(" /> ");
            this.putLineComment("Ref:" + linkedBone.getBoneName().getText());
            this.ln(2);
        }
        RigidShape shape = rigid.getRigidShape();
        this.putRigidShape(shape);
        MkPos3D position = rigid.getPosition();
        this.ind().putPosition(position).ln();
        Rad3d rotation = rigid.getRotation();
        this.ind().putRadRotation(rotation).ln();
        DynamicsInfo dynamics = rigid.getDynamicsInfo();
        this.putDynamics(dynamics).ln();
        for (RigidGroup group : rigid.getThroughGroupColl()) {
            this.ind().putRawText("<throughRigidGroup ");
            this.putNumberedIdAttr((CharSequence)"rigidGroupIdRef", (CharSequence)PFX_RIGIDGROUP, group.getSerialNumber() + 1).sp();
            this.putRawText(" />").ln();
        }
        this.popNest();
        this.ind().putRawText("</rigid>").ln(2);
        return this;
    }

    private XmlExporter putRigidShape(RigidShape shape) throws IOException {
        RigidShapeType type = shape.getShapeType();
        switch (type) {
            case BOX: {
                this.ind().putRawText("<rigidShapeBox ");
                this.putFloatAttr("width", shape.getWidth()).sp();
                this.putFloatAttr("height", shape.getHeight()).sp();
                this.putFloatAttr("depth", shape.getDepth()).sp();
                break;
            }
            case SPHERE: {
                this.ind().putRawText("<rigidShapeSphere ");
                this.putFloatAttr("radius", shape.getRadius()).sp();
                break;
            }
            case CAPSULE: {
                this.ind().putRawText("<rigidShapeCapsule ");
                this.putFloatAttr("height", shape.getHeight()).sp();
                this.putFloatAttr("radius", shape.getRadius()).sp();
                break;
            }
            default: {
                assert (false);
                throw new AssertionError();
            }
        }
        this.putRawText("/>").ln();
        return this;
    }

    private XmlExporter putDynamics(DynamicsInfo dynamics) throws IOException {
        this.ind().putRawText("<dynamics").ln();
        this.pushNest();
        this.ind().putFloatAttr("mass", dynamics.getMass()).ln();
        this.ind().putFloatAttr("dampingPosition", dynamics.getDampingPosition()).ln();
        this.ind().putFloatAttr("dampingRotation", dynamics.getDampingRotation()).ln();
        this.ind().putFloatAttr("restitution", dynamics.getRestitution()).ln();
        this.ind().putFloatAttr("friction", dynamics.getFriction()).ln();
        this.popNest();
        this.ind().putRawText("/>").ln();
        return this;
    }

    private XmlExporter putRigidGroupList(PmdModel model) throws IOException {
        this.ind().putRawText("<rigidGroupList>").ln(2);
        this.pushNest();
        boolean singleLast = false;
        for (RigidGroup group : model.getRigidGroupList()) {
            List<RigidInfo> rigidList = group.getRigidList();
            if (singleLast && !rigidList.isEmpty()) {
                this.ln();
            }
            this.ind().putRawText("<rigidGroup ");
            this.putNumberedIdAttr((CharSequence)"rigidGroupId", (CharSequence)PFX_RIGIDGROUP, group.getSerialNumber() + 1);
            if (rigidList.isEmpty()) {
                this.putRawText(" />").ln();
                singleLast = true;
                continue;
            }
            this.putRawText(" >").ln();
            this.pushNest();
            for (RigidInfo rigid : rigidList) {
                this.ind().putRawText("<rigidGroupMember ");
                this.putNumberedIdAttr((CharSequence)"rigidIdRef", (CharSequence)PFX_RIGID, rigid).sp();
                this.putRawText("/>");
                this.sp();
                this.putLineComment("Ref:" + rigid.getRigidName().getText());
                this.ln();
            }
            this.popNest();
            this.ind().putRawText("</rigidGroup>").ln(2);
            singleLast = false;
        }
        if (singleLast) {
            this.ln();
        }
        this.popNest();
        this.ind().putRawText("</rigidGroupList>").ln(2);
        return this;
    }

    private XmlExporter putJointList(PmdModel model) throws IOException {
        this.ind().putRawText("<jointList>").ln();
        this.pushNest();
        boolean dumped = false;
        List<JointInfo> jointList = model.getJointList();
        for (JointInfo joint : jointList) {
            if (!dumped) {
                this.ln();
            }
            this.putJoint(joint);
            dumped = true;
        }
        this.popNest();
        this.ind().putRawText("</jointList>").ln(2);
        return this;
    }

    private XmlExporter putJoint(JointInfo joint) throws IOException {
        I18nText i18nName = joint.getJointName();
        this.putLocalNameComment(i18nName).ln();
        this.ind().putRawText("<joint ");
        this.putPrimaryNameAttr("name", i18nName);
        this.sp().putRawText(">").ln();
        this.pushNest();
        this.putI18nName(i18nName);
        RigidInfo rigidA = joint.getRigidA();
        RigidInfo rigidB = joint.getRigidB();
        this.ind();
        this.putLineComment("[" + rigidA.getRigidName().getText() + "]" + " <=> [" + rigidB.getRigidName().getText() + "]");
        this.ln();
        this.ind().putRawText("<jointedRigidPair ");
        this.putNumberedIdAttr((CharSequence)"rigidIdRef1", (CharSequence)PFX_RIGID, rigidA).sp();
        this.putNumberedIdAttr((CharSequence)"rigidIdRef2", (CharSequence)PFX_RIGID, rigidB).sp();
        this.putRawText("/>").ln(2);
        MkPos3D position = joint.getPosition();
        this.ind().putPosition(position).ln();
        TripletRange posRange = joint.getPositionRange();
        this.ind().putRawText("<limitPosition").ln();
        this.pushNest();
        this.ind();
        this.putFloatAttr("xFrom", posRange.getXFrom()).sp();
        this.putFloatAttr("xTo", posRange.getXTo()).ln();
        this.ind();
        this.putFloatAttr("yFrom", posRange.getYFrom()).sp();
        this.putFloatAttr("yTo", posRange.getYTo()).ln();
        this.ind();
        this.putFloatAttr("zFrom", posRange.getZFrom()).sp();
        this.putFloatAttr("zTo", posRange.getZTo()).ln();
        this.popNest();
        this.ind().putRawText("/>").ln(2);
        Rad3d rotation = joint.getRotation();
        this.ind().putRadRotation(rotation).ln();
        TripletRange rotRange = joint.getRotationRange();
        this.ind().putRawText("<limitRotation").ln();
        this.pushNest();
        this.ind();
        this.putFloatAttr("xFrom", rotRange.getXFrom()).sp();
        this.putFloatAttr("xTo", rotRange.getXTo()).ln();
        this.ind();
        this.putFloatAttr("yFrom", rotRange.getYFrom()).sp();
        this.putFloatAttr("yTo", rotRange.getYTo()).ln();
        this.ind();
        this.putFloatAttr("zFrom", rotRange.getZFrom()).sp();
        this.putFloatAttr("zTo", rotRange.getZTo()).ln();
        this.popNest();
        this.ind().putRawText("/>").ln(2);
        MkPos3D elaPosition = joint.getElasticPosition();
        this.ind().putRawText("<elasticPosition ");
        this.putFloatAttr("x", (float)elaPosition.getXpos()).sp();
        this.putFloatAttr("y", (float)elaPosition.getYpos()).sp();
        this.putFloatAttr("z", (float)elaPosition.getZpos()).sp();
        this.putRawText("/>").ln();
        Deg3d elaRotation = joint.getElasticRotation();
        this.ind().putRawText("<elasticRotation ");
        this.putFloatAttr("xDeg", elaRotation.getXDeg()).sp();
        this.putFloatAttr("yDeg", elaRotation.getYDeg()).sp();
        this.putFloatAttr("zDeg", elaRotation.getZDeg()).sp();
        this.putRawText("/>").ln(2);
        this.popNest();
        this.ind().putRawText("</joint>").ln(2);
        return this;
    }
}

