/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd2xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.util.Properties;
import jp.sfjp.mikutoga.pmd2xml.CmdLineException;
import jp.sfjp.mikutoga.pmd2xml.OptInfo;
import jp.sfjp.mikutoga.pmd2xml.OptSwitch;
import jp.sfjp.mikutoga.pmd2xml.Pmd2XmlConv;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.pmd.IllegalPmdDataException;
import jp.sourceforge.mikutoga.xml.TogaXmlException;
import org.xml.sax.SAXException;

public final class Pmd2Xml {
    public static final int EXIT_OK = 0;
    public static final int EXIT_FILE = 1;
    public static final int EXIT_XML = 2;
    public static final int EXIT_PMD = 3;
    public static final int EXIT_JREVER = 4;
    public static final int EXIT_OPT = 5;
    public static final int EXIT_INTERN = 6;
    public static final String APPNAME;
    public static final String APPVER;
    public static final String APPLICENSE;
    private static final Class<?> THISCLASS;
    private static final PrintStream ERROUT;

    private Pmd2Xml() {
        assert (this.getClass().equals(THISCLASS));
    }

    private static void exit(int code) {
        System.exit(code);
    }

    private static void errPrintln(Throwable ex, boolean dumpStack) {
        String text = ex.toString();
        ERROUT.println(text);
        if (dumpStack) {
            ex.printStackTrace(ERROUT);
        }
    }

    private static void errPrintln(Throwable ex) {
        Pmd2Xml.errPrintln(ex, false);
    }

    private static void errMsg(String text) {
        ERROUT.println("ERROR:");
        ERROUT.println(text);
        ERROUT.println("(-h for help)");
    }

    private static void ioError(Throwable ex) {
        Pmd2Xml.errPrintln(ex);
        Pmd2Xml.exit(1);
    }

    private static void xmlError(Throwable ex) {
        Pmd2Xml.errPrintln(ex);
        Pmd2Xml.exit(2);
    }

    private static void pmdError(Throwable ex) {
        Pmd2Xml.errPrintln(ex, true);
        Pmd2Xml.exit(3);
    }

    private static void internalError(Throwable ex) {
        Pmd2Xml.errPrintln(ex, true);
        Pmd2Xml.exit(6);
    }

    private static void checkJRE() {
        Package jrePackage = Object.class.getPackage();
        if (!jrePackage.isCompatibleWith("1.6")) {
            ERROUT.println("You need JRE 1.6 or later.");
            Pmd2Xml.exit(4);
        }
    }

    private static void putHelp() {
        StringBuilder appInfo = new StringBuilder();
        String indent = "  ";
        appInfo.append(APPNAME).append(' ').append(APPVER).append('\n');
        appInfo.append(indent).append("License").append(" : ").append(APPLICENSE).append('\n');
        appInfo.append(indent).append("http://mikutoga.sourceforge.jp/").append('\n');
        ERROUT.println(appInfo.toString());
        ERROUT.println(OptSwitch.getConsoleHelp());
    }

    private static void trunc(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.isFile()) {
            return;
        }
        FileOutputStream foStream = new FileOutputStream(file);
        FileChannel channnel = foStream.getChannel();
        channnel.truncate(0L);
        channnel.close();
        foStream.close();
    }

    private static InputStream openInfile(String fileName) {
        InputStream is;
        block3: {
            File inFile = new File(fileName);
            if (!inFile.exists() || !inFile.isFile()) {
                String absPath = inFile.getAbsolutePath();
                Pmd2Xml.errMsg("Can't find input file:" + absPath);
                Pmd2Xml.exit(1);
            }
            is = null;
            try {
                is = new FileInputStream(inFile);
            }
            catch (FileNotFoundException e) {
                Pmd2Xml.ioError(e);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        is = new BufferedInputStream(is);
        return is;
    }

    private static OutputStream openOutfile(String fileName, boolean overWrite) {
        OutputStream os;
        block8: {
            File outFile = new File(fileName);
            if (outFile.exists()) {
                String msg;
                String absPath = outFile.getAbsolutePath();
                if (!outFile.isFile()) {
                    msg = absPath + " is not file.";
                    Pmd2Xml.errMsg(msg);
                    Pmd2Xml.exit(1);
                } else if (!overWrite) {
                    msg = absPath + " already exists.\n" + "If you want to overwrite, use -f.";
                    Pmd2Xml.errMsg(msg);
                    Pmd2Xml.exit(1);
                }
            }
            try {
                Pmd2Xml.trunc(outFile);
            }
            catch (IOException e) {
                Pmd2Xml.ioError(e);
            }
            os = null;
            try {
                os = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                Pmd2Xml.ioError(e);
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        os = new BufferedOutputStream(os);
        return os;
    }

    public static void main(String[] args) {
        OptInfo optInfo;
        Pmd2Xml.checkJRE();
        Pmd2XmlConv converter = new Pmd2XmlConv();
        try {
            optInfo = OptInfo.parseOption(args);
        }
        catch (CmdLineException e) {
            String optErrMsg = e.getLocalizedMessage();
            Pmd2Xml.errMsg(optErrMsg);
            Pmd2Xml.exit(5);
            return;
        }
        if (optInfo.needHelp()) {
            Pmd2Xml.putHelp();
            Pmd2Xml.exit(0);
        }
        String inputFile = optInfo.getInFilename();
        String outputFile = optInfo.getOutFilename();
        boolean overwrite = optInfo.overwriteMode();
        InputStream is = Pmd2Xml.openInfile(inputFile);
        OutputStream os = Pmd2Xml.openOutfile(outputFile, overwrite);
        converter.setInType(optInfo.getInFileType());
        converter.setOutType(optInfo.getOutFileType());
        converter.setNewline(optInfo.getNewline());
        converter.setGenerator(optInfo.getGenerator());
        try {
            converter.convert(is, os);
        }
        catch (IOException e) {
            Pmd2Xml.ioError(e);
        }
        catch (IllegalPmdDataException e) {
            Pmd2Xml.internalError(e);
        }
        catch (MmdFormatException e) {
            Pmd2Xml.pmdError(e);
        }
        catch (TogaXmlException e) {
            Pmd2Xml.xmlError(e);
        }
        catch (SAXException e) {
            Pmd2Xml.xmlError(e);
        }
        try {
            is.close();
            try {
                os.close();
            }
            catch (IOException e) {
                Pmd2Xml.ioError(e);
            }
        }
        catch (IOException e) {
            Pmd2Xml.ioError(e);
        }
        Pmd2Xml.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ERROUT = System.err;
        THISCLASS = Pmd2Xml.class;
        InputStream ver = THISCLASS.getResourceAsStream("resources/version.properties");
        Properties verProps = new Properties();
        try {
            try {
                verProps.load(ver);
            }
            finally {
                ver.close();
            }
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        APPNAME = verProps.getProperty("app.name");
        APPVER = verProps.getProperty("app.version");
        APPLICENSE = verProps.getProperty("app.license");
        new Pmd2Xml().hashCode();
    }
}

