/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd2xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import jp.sfjp.mikutoga.pmd.binio.PmdExporter;
import jp.sfjp.mikutoga.pmd.binio.PmdLoader;
import jp.sfjp.mikutoga.pmd.model.PmdModel;
import jp.sfjp.mikutoga.pmd.xml.BotherHandler;
import jp.sfjp.mikutoga.pmd.xml.LocalSchema;
import jp.sfjp.mikutoga.pmd.xml.Schema101009;
import jp.sfjp.mikutoga.pmd.xml.Schema130128;
import jp.sfjp.mikutoga.pmd.xml.XmlExporter;
import jp.sfjp.mikutoga.pmd.xml.XmlLoader;
import jp.sfjp.mikutoga.pmd.xml.XmlModelFileType;
import jp.sfjp.mikutoga.pmd2xml.ModelFileType;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.pmd.IllegalPmdDataException;
import jp.sourceforge.mikutoga.xml.TogaXmlException;
import jp.sourceforge.mikutoga.xml.XmlResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Pmd2XmlConv {
    private ModelFileType inTypes = ModelFileType.NONE;
    private ModelFileType outTypes = ModelFileType.NONE;
    private String newLine = "\r\n";
    private String generator = null;

    private static void initBuilderFactory(DocumentBuilderFactory builderFactory) {
        builderFactory.setCoalescing(true);
        builderFactory.setExpandEntityReferences(true);
        builderFactory.setIgnoringComments(true);
        builderFactory.setIgnoringElementContentWhitespace(false);
        builderFactory.setNamespaceAware(true);
        builderFactory.setValidating(false);
        builderFactory.setXIncludeAware(false);
    }

    private DocumentBuilder buildBuilder() {
        DocumentBuilder result;
        Schema schema;
        XmlResourceResolver resolver = new XmlResourceResolver();
        switch (this.inTypes) {
            case XML_101009: {
                schema = LocalSchema.newSchema(resolver, new Schema101009());
                break;
            }
            case XML_130128: {
                schema = LocalSchema.newSchema(resolver, new Schema130128());
                break;
            }
            case XML_AUTO: {
                schema = LocalSchema.newSchema(resolver, new Schema101009(), new Schema130128());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        Pmd2XmlConv.initBuilderFactory(builderFactory);
        builderFactory.setSchema(schema);
        try {
            result = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        result.setEntityResolver(resolver);
        result.setErrorHandler(BotherHandler.HANDLER);
        return result;
    }

    public void setInType(ModelFileType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == ModelFileType.NONE) {
            throw new IllegalArgumentException();
        }
        this.inTypes = type;
    }

    public ModelFileType getInTypes() {
        return this.inTypes;
    }

    public void setOutType(ModelFileType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == ModelFileType.NONE) {
            throw new IllegalArgumentException();
        }
        this.outTypes = type;
    }

    public ModelFileType getOutTypes() {
        return this.outTypes;
    }

    public void setNewline(String newline) {
        this.newLine = newline;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void convert(InputStream is, OutputStream os) throws IOException, MmdFormatException, SAXException, TogaXmlException, IllegalPmdDataException {
        PmdModel model = this.readModel(is);
        this.writeModel(model, os);
    }

    public PmdModel readModel(InputStream is) throws IOException, MmdFormatException, SAXException, TogaXmlException {
        PmdModel model = null;
        if (this.inTypes.isPmd()) {
            model = this.pmdRead(is);
        } else if (this.inTypes.isXml()) {
            model = this.xmlRead(is);
        } else {
            throw new IllegalStateException();
        }
        return model;
    }

    public void writeModel(PmdModel model, OutputStream os) throws IOException, IllegalPmdDataException {
        if (this.outTypes.isPmd()) {
            this.pmdOut(model, os);
        } else if (this.outTypes.isXml()) {
            this.xmlOut(model, os);
        } else {
            throw new IllegalStateException();
        }
    }

    private PmdModel pmdRead(InputStream is) throws IOException, MmdFormatException {
        PmdLoader loader = new PmdLoader(is);
        PmdModel model = loader.load();
        return model;
    }

    private PmdModel xmlRead(InputStream is) throws IOException, SAXException, TogaXmlException {
        InputSource source = new InputSource(is);
        PmdModel result = this.xmlRead(source);
        return result;
    }

    private PmdModel xmlRead(InputSource source) throws IOException, SAXException, TogaXmlException {
        DocumentBuilder builder = this.buildBuilder();
        XmlLoader loader = new XmlLoader();
        PmdModel model = loader.parse(builder, source);
        return model;
    }

    private void pmdOut(PmdModel model, OutputStream ostream) throws IOException, IllegalPmdDataException {
        PmdExporter exporter = new PmdExporter(ostream);
        exporter.dumpPmdModel(model);
        ostream.close();
    }

    private void xmlOut(PmdModel model, OutputStream ostream) throws IOException, IllegalPmdDataException {
        XmlExporter exporter = new XmlExporter(ostream);
        XmlModelFileType xmlType = this.outTypes.toXmlType();
        exporter.setXmlFileType(xmlType);
        exporter.setNewLine(this.newLine);
        exporter.setGenerator(this.generator);
        exporter.putPmdModel(model);
        exporter.close();
    }
}

