/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.xml;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public class BasicXmlExporter {
    private static final Charset CS_UTF8 = Charset.forName("UTF-8");
    private static final String DEF_NL = "\n";
    private static final String DEF_INDENT_UNIT = "  ";
    private static final char CH_SP = ' ';
    private static final char CH_YEN = '\u00a5';
    private static final char CH_BSLASH = '\\';
    private static final char CH_DQ = '\"';
    private static final char CH_SQ = '\'';
    private static final String COMM_START = "<!--";
    private static final String COMM_END = "-->";
    private static final String REF_HEX = "&#x";
    private static final Pattern NUM_FUZZY = Pattern.compile("([^.]*\\.[0-9][0-9]*?)0+");
    private static final int HEX_EXP = 4;
    private static final int MASK_1HEX = 15;
    private static final int MAX_OCTET = 255;
    private static final char[] HEXCHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Appendable appendable;
    private String newline = "\n";
    private String indentUnit = "  ";
    private int indentNest = 0;
    private boolean basicLatinOnlyOut = true;

    public BasicXmlExporter(OutputStream stream) {
        this(stream, CS_UTF8);
    }

    public BasicXmlExporter(OutputStream stream, Charset charSet) {
        this(new BufferedWriter(new OutputStreamWriter(stream, charSet)));
    }

    public BasicXmlExporter(Appendable appendable) {
        this.appendable = appendable;
    }

    public static boolean isBasicLatin(char ch) {
        return '\u0000' <= ch && ch <= '\u007f';
    }

    public static String chopFuzzyZero(String numTxt) {
        Matcher matcher = NUM_FUZZY.matcher(numTxt);
        String result = matcher.matches() ? matcher.group(1) : numTxt;
        return result;
    }

    public void setBasicLatinOnlyOut(boolean bool) {
        this.basicLatinOnlyOut = bool;
    }

    public boolean isBasicLatinOnlyOut() {
        return this.basicLatinOnlyOut;
    }

    public void setNewLine(String newLine) throws NullPointerException {
        if (newLine == null) {
            throw new NullPointerException();
        }
        this.newline = newLine;
    }

    public String getNewLine() {
        return this.newline;
    }

    public void setIndentUnit(String indUnit) throws NullPointerException {
        if (indUnit == null) {
            throw new NullPointerException();
        }
        this.indentUnit = indUnit;
    }

    public String getIndentUnit() {
        return this.indentUnit;
    }

    public void flush() throws IOException {
        if (this.appendable instanceof Flushable) {
            ((Flushable)((Object)this.appendable)).flush();
        }
    }

    public void close() throws IOException {
        if (this.appendable instanceof Closeable) {
            ((Closeable)((Object)this.appendable)).close();
        }
    }

    public BasicXmlExporter putRawCh(char ch) throws IOException {
        this.appendable.append(ch);
        return this;
    }

    public BasicXmlExporter putRawText(CharSequence seq) throws IOException {
        this.appendable.append(seq);
        return this;
    }

    public BasicXmlExporter putCharRef2Hex(char ch) throws IOException {
        if (ch > 255) {
            return this.putCharRef4Hex((char)ch);
        }
        int ibits = ch;
        int idx4 = ibits & 0xF;
        int idx3 = (ibits >>= 4) & 0xF;
        char hex3 = HEXCHAR_TABLE[idx3];
        char hex4 = HEXCHAR_TABLE[idx4];
        this.putRawText(REF_HEX).putRawCh(hex3).putRawCh(hex4).putRawCh(';');
        return this;
    }

    public BasicXmlExporter putCharRef4Hex(char ch) throws IOException {
        int ibits = ch;
        int idx4 = ibits & 0xF;
        int idx3 = (ibits >>= 4) & 0xF;
        int idx2 = (ibits >>= 4) & 0xF;
        int idx1 = (ibits >>= 4) & 0xF;
        char hex1 = HEXCHAR_TABLE[idx1];
        char hex2 = HEXCHAR_TABLE[idx2];
        char hex3 = HEXCHAR_TABLE[idx3];
        char hex4 = HEXCHAR_TABLE[idx4];
        this.putRawText(REF_HEX).putRawCh(hex1).putRawCh(hex2).putRawCh(hex3).putRawCh(hex4).putRawCh(';');
        return this;
    }

    public BasicXmlExporter putCh(char ch) throws IOException {
        String escTxt;
        if (Character.isISOControl(ch)) {
            this.putCharRef2Hex(ch);
            return this;
        }
        switch (ch) {
            case '&': {
                escTxt = "&amp;";
                break;
            }
            case '<': {
                escTxt = "&lt;";
                break;
            }
            case '>': {
                escTxt = "&gt;";
                break;
            }
            case '\"': {
                escTxt = "&quot;";
                break;
            }
            case '\'': {
                escTxt = "&apos;";
                break;
            }
            default: {
                escTxt = null;
            }
        }
        if (escTxt != null) {
            this.putRawText(escTxt);
        } else {
            this.putRawCh(ch);
        }
        return this;
    }

    public BasicXmlExporter putContent(CharSequence content) throws IOException {
        int length = content.length();
        char prev = '\u0000';
        for (int pos = 0; pos < length; ++pos) {
            char ch = content.charAt(pos);
            if (this.isBasicLatinOnlyOut() && !BasicXmlExporter.isBasicLatin(ch)) {
                this.putCharRef4Hex(ch);
            } else if (ch == '\u00a5') {
                this.putRawCh('\\');
            } else if (Character.isSpaceChar(ch)) {
                if (ch == ' ' && prev != ' ') {
                    this.putRawCh(ch);
                } else {
                    this.putCharRef2Hex(ch);
                }
            } else {
                this.putCh(ch);
            }
            prev = ch;
        }
        return this;
    }

    public BasicXmlExporter ln() throws IOException {
        this.appendable.append(this.newline);
        return this;
    }

    public BasicXmlExporter ln(int count) throws IOException {
        for (int ct = 1; ct <= count; ++ct) {
            this.appendable.append(this.newline);
        }
        return this;
    }

    public BasicXmlExporter sp() throws IOException {
        this.appendable.append(' ');
        return this;
    }

    public BasicXmlExporter sp(int count) throws IOException {
        for (int ct = 1; ct <= count; ++ct) {
            this.appendable.append(' ');
        }
        return this;
    }

    public BasicXmlExporter ind() throws IOException {
        for (int ct = 1; ct <= this.indentNest; ++ct) {
            this.putRawText(this.indentUnit);
        }
        return this;
    }

    public void pushNest() {
        ++this.indentNest;
    }

    public void popNest() {
        --this.indentNest;
        if (this.indentNest < 0) {
            this.indentNest = 0;
        }
    }

    public BasicXmlExporter putXsdInt(int iVal) throws IOException {
        String value = DatatypeConverter.printInt((int)iVal);
        this.appendable.append(value);
        return this;
    }

    public BasicXmlExporter putXsdFloat(float fVal) throws IOException {
        String value = DatatypeConverter.printFloat((float)fVal);
        this.appendable.append(value);
        return this;
    }

    public BasicXmlExporter putAttr(CharSequence attrName, CharSequence content) throws IOException {
        this.putRawText(attrName).putRawCh('=');
        this.putRawCh('\"');
        this.putContent(content);
        this.putRawCh('\"');
        return this;
    }

    public BasicXmlExporter putIntAttr(CharSequence attrName, int iVal) throws IOException {
        String attrValue = DatatypeConverter.printInt((int)iVal);
        this.putAttr(attrName, attrValue);
        return this;
    }

    public BasicXmlExporter putFloatAttr(CharSequence attrName, float fVal) throws IOException {
        String attrValue = DatatypeConverter.printFloat((float)fVal);
        attrValue = BasicXmlExporter.chopFuzzyZero(attrValue);
        this.putAttr(attrName, attrValue);
        return this;
    }

    public BasicXmlExporter putCommentContent(CharSequence comment) throws IOException {
        int length = comment.length();
        char prev = '\u0000';
        for (int pos = 0; pos < length; ++pos) {
            char ch = comment.charAt(pos);
            if (ch == '\n') {
                this.ln();
            } else if ('\u0000' <= ch && ch <= '\u001f') {
                this.putRawCh((char)(9216 + ch));
            } else if (ch == '\u007f') {
                this.putRawCh('\u2421');
            } else if (prev == '-' && ch == '-') {
                this.sp().putRawCh(ch);
            } else {
                this.putRawCh(ch);
            }
            prev = ch;
        }
        return this;
    }

    public BasicXmlExporter putLineComment(CharSequence comment) throws IOException {
        this.putRawText(COMM_START).sp();
        this.putCommentContent(comment);
        this.sp().putRawText(COMM_END);
        return this;
    }

    public BasicXmlExporter putBlockComment(CharSequence comment) throws IOException {
        char lastCh;
        this.putRawText(COMM_START).ln();
        this.putCommentContent(comment);
        int commentLength = comment.length();
        if (commentLength > 0 && (lastCh = comment.charAt(commentLength - 1)) != '\n') {
            this.ln();
        }
        this.putRawText(COMM_END).ln();
        return this;
    }

    static {
        assert (HEXCHAR_TABLE.length == 16);
    }
}

