# -*- rd -*-

= Install to CentOS (optional) --- How to install milter manager related softwares to CentOS

== About this document

This document describes how to install milter manager
related softwares to CentOS. See ((<Install to
CentOS|install-to-centos.rd>)) for milter manager install
information and ((<Install|install.rd>)) for general install
information.

== [centos-milter-manager-log-analyzer] Install milter-manager-log-analyzer

milter-manager-log-analyzer is already installed because it
is included in milter manager's RPM package. We will
configure Web server to browse graphs generated by
milter-manager-log-analyzer.

=== Install packages

We use Apache as Web server.

  % sudo yum install -y httpd
  % sudo /sbin/chkconfig httpd on

=== Configure milter-manager-log-analyzer

milter-manager-log-analyzer generates graphs to
milter-manager user's home
directory. (/var/lib/milter-manager/) We configure Web
server to publish them at
http://localhost/milter-manager-log/.

We put /etc/httpd/conf.d/milter-manager-log.conf with the
following content:
  Alias /milter-manager-log/ /var/lib/milter-manager/public_html/log/

We need to reload configuration after editing:

  % sudo /sbin/service httpd reload

Now, we can see graphs at http://localhost/milter-manager-log/.

== [centos-milter-manager-admin] Install milter manager admin

=== Install packages

To install the following packages, related packages are also
installed:

  % sudo yum install -y ruby-rdoc gcc-c++ httpd-devel sqlite-devel

=== Install RubyGems

  % cd ~/src/
  % wget http://rubyforge.org/frs/download.php/45905/rubygems-1.3.1.tgz
  % tar xvzf rubygems-1.3.1.tgz
  % cd rubygems-1.3.1
  % sudo ruby setup.rb

=== Instal gems

  % sudo gem install sqlite3-ruby
  % sudo gem install rails -v '2.3.2'
  % sudo gem install passenger -v '2.2.4'

=== Install Passenger

To build Passenger we run the following command:

  % (echo 1; echo) | sudo passenger-install-apache2-module

It's difficult that Passenger runs on SELinux. (It's not
good but) We disable SELinux just for Apache because HTTP
accesses from other hosts are blocked by default. We will
update this section when we know better other solution.

  % sudo /usr/sbin/setsebool httpd_disable_trans true

We create milter-manager.conf under /etc/httpd/conf.d/.

/etc/httpd/conf.d/milter-manager.conf:
  LoadModule passenger_module /usr/lib/ruby/gems/1.8/gems/passenger-2.2.4/ext/apache2/mod_passenger.so
  PassengerRoot /usr/lib/ruby/gems/1.8/gems/passenger-2.2.4
  PassengerRuby /usr/bin/ruby

  RailsBaseURI /milter-manager

We need to reload configuration.

  % sudo /sbin/service httpd reload

=== Configure milter manager admin

milter manager admin is installed to
/usr/share/milter-manager/admin/. We run it as
milter-manager user authority, and access it at
http://localhost/milter-manager/.

  % tar cf - -C /usr/share/milter-manager admin | sudo -u milter-manager -H tar xf - -C ~milter-manager
  % sudo ln -s ~milter-manager/admin/public /var/www/html/milter-manager
  % cd ~milter-manager/admin
  % sudo -u milter-manager -H rake gems:install
  % sudo -u milter-manager -H rake RAILS_ENV=production db:migrate

Then we create a file to
~milter-manager/admin/config/initializers/relative_url_root.rb
with the following content:

~milter-manager/admin/config/initializers/relative_url_root.rb
  ActionController::Base.relative_url_root = "/milter-manager"

Now, we can access to http://localhost/milter-manager/. The
first work is registering a user. We will move to
milter-manager connection configuration page after register
a user. We can confirm where milter-manager accepts control
connection:

  % sudo -u milter-manager -H /usr/sbin/milter-manager --show-config | grep controller.connection_spec
  controller.connection_spec = "unix:/var/run/milter-manager/milter-manager-controller.sock"

We register confirmed value by browser. In the above case,
we select "unix" from "Type" at first. "Path" will be
appeared. We specify
"/var/run/milter-manager/milter-manager-controller.sock" to "Path".

We can confirm registered child milters and their
configuration by browser.

== Conclusion

We can confirm milter's effect visually by
milter-manager-log-analyzer. If we use Postfix as MTA, we
can compare with
((<Mailgraph|URL:http://mailgraph.schweikert.ch/>))'s graphs
to confirm milter's effect. We can use graphs generated by
milter-manager-log-analyzer effectively when we are trying
out a milter.

We can reduce administration cost by using milter manager
admin. Because we can change configurations without editing
configuration file.

It's convenient that we can enable and/or disable milters by
browser when we try out milters. We can use graphs generated
by milter-manager-log-analyzer to find what is the best milter
combination for our mail system.
