import time

class MindMapRoot:
  def __init__(self, message):
    self.decode_map = {None:None}
    self.counter = 0
    self.add(None, message)
    self.child = self.decode_map['0']

  def add(self, code, message):
    parent = self.decode_map[code]
    child = MindMap(message)
    if parent != None:
      parent.addChild(child)
      child.color = parent.getColor()
    child.setCode(str(self.counter))
    self.counter += 1
    self.decode_map[child.code] = child
    return child.code

  def change(self, code, message, color, link, linkType):
    child = self.decode_map[code]
    child.change(message, color)
    child.link = link
    child.linkType = linkType

  def refresh(self):
    self.child.refresh()

  def createFromXML(self, xml_string):
    from xml.dom.minidom import parseString
    dom = parseString(xml_string)
    rootNode = self.rootNode(dom)
    message = rootNode._attrs['TEXT'].value.encode('utf-8')
    root = MindMapRoot(message)
    self.createFromXMLOne(root, rootNode, '0')
    return root

  def rootNode(self, dom):
    mapNode = dom.childNodes[0]
    for childNode in mapNode.childNodes:
      if childNode.nodeName == 'node':    
        return childNode    

  def createFromXMLOne(self, root, node, code):
    for childNode in node.childNodes:
      if childNode.nodeName == 'node':
        message = childNode._attrs['TEXT'].value.encode('utf-8')
        childCode = root.add(code, message)
        self.createFromXMLOne(root, childNode, childCode)

class Birthday:
  def __init__(self):
    self.rebirth()

  def amountOfSecond(self):
    if not hasattr(self, 'time'): #
      self.time = 0               #
    return time.time() - self.time

  def rebirth(self):
    self.time = time.time()

class Composite:
  def __init__(self):
    self.children = []

  def addChild(self, child):
    self.children.append(child)

  def removeChild(self, child):
    self.children.remove(child)

class MindMap(Birthday, Composite):
  def __init__(self, message):
    Birthday.__init__(self)
    Composite.__init__(self)
    self.message = message
    self.link = ''
    self.linkType = ''
    self.code = 0
    self.color = 'black'

  def getColor(self):
    if self.color == "":
      self.color = "black"
    return self.color

  def setCode(self, code):
    self.code = code

  def change(self, message, color):
    self.message = message
    self.color = color
    self.rebirth()

  def refresh(self):
    for child in self.children:
      child.refresh()

    for child in self.children:
      if child.message == "":
        if child.children == []:
          self.removeChild(child)

class OrderedSet:
  pass
