import time

class XML2MindMapRoot:
  def createFromXML(self, xml_string):
    from xml.dom.minidom import parseString
    dom = parseString(xml_string)
    node = dom.childNodes[0]
    mmr = MindMapRoot()
    self.createFromXMLOne(mmr, node, None)
    return mmr

  def createFromXMLOne(self, mmr, node, parent_code):
    for childNode in node.childNodes:
      if childNode.nodeName == 'node':
        message = childNode._attrs['TEXT'].value.encode('utf-8')
        color = childNode._attrs['color'].value.encode('utf-8')
        child = mmr.add(parent_code, message)
        child.setColor(color) #
        self.createFromXMLOne(mmr, childNode, child.code)

class Counter:
  def __init__(self):
    self.counter = 0

  def nextCount(self):
    counter = self.counter
    self.counter += 1
    return counter

class MindMapRoot(Counter):
  def __init__(self):
    Counter.__init__(self)
    self.decode_map = {}

  def add(self, parent_code, message):
    child = MindMap(message)
    if parent_code != None:
      parent = self.decode_map[parent_code]
      parent.addChild(child)
      child.color = parent.getColor()
    child.setCode(str(self.nextCount()))
    self.decode_map[child.code] = child
    return child

  def change(self, code, message, color, link, linkType):
    child = self.decode_map[code]
    child.change(message, color)
    child.link = link
    child.linkType = linkType

  def refresh(self):
    self.getRoot().refresh()

  def getRoot(self):
    return self.decode_map['0']

class Birthday:
  def __init__(self):
    self.rebirth()

  def amountOfSecond(self):
    return time.time() - self.time

  def rebirth(self):
    self.time = time.time()

class Composite:
  def __init__(self):
    self.children = []
    self.parent = None

  def addChild(self, child, index = None):
    if index == None:
      self.children.append(child)
    else:
      self.children.insert(index, child)      
    child.parent = self

  def removeChild(self, child):
    self.children.remove(child)
    child.parent = None

  def moveForward(self):
    parent = self.parent
    if parent == None:
      return
    index = parent.children.index(self)
    parent.removeChild(self)
    parent.addChild(self, index - 1)

  def moveBack(self):
    parent = self.parent
    if parent == None:
      return
    index = parent.children.index(self)
    parent.removeChild(self)
    parent.addChild(self, index + 1)

  def moveUp(self):
    parent = self.parent
    if parent == None:
      return
    grand_parent = parent.parent
    if grand_parent == None:
      return 
    index = grand_parent.children.index(parent)
    parent.removeChild(self)
    grand_parent.addChild(self, index + 1)

  def moveDown(self):
    parent = self.parent
    if parent == None:
      return
    index = parent.children.index(self)
    if index == 0:
      return
    
    brother = parent.children[index - 1]
    parent.removeChild(self)
    brother.addChild(self)

class MindMap(Birthday, Composite):
  def __init__(self, message):
    Birthday.__init__(self)
    Composite.__init__(self)
    self.message = message
    self.link = ''
    self.linkType = ''
    self.code = 0
    self.color = 'black'

  def getColor(self):
    return self.color

  def setColor(self, color):
    self.color = color

  def setCode(self, code):
    self.code = code

  def change(self, message, color):
    self.message = message
    self.color = color
    self.rebirth()

  def refresh(self):
    self.parent = None
    for child in self.children:
      child.refresh()
      child.parent = self

    for child in self.children:
      if child.message == "":
        if child.children == []:
          self.removeChild(child)
