import unittest
import time
from Birthday import Birthday

def mockTime():
  return time.mktime((2004, 1, 11, 14, 38, 44, 6, 11, 0))

class BirthdayTestCase(unittest.TestCase):
  import time
  def setUp(self):
    self.original_time = time.time
    time.time = mockTime
    self.birthday = Birthday()

  def testTime(self):
    self.assertEqual(time.mktime((2004, 1, 11, 14, 38, 44, 6, 11, 0)),
                     self.birthday.time)

  def testAmountOfSecond(self):
    self.birthday.time = time.mktime((2004, 1, 11, 14, 38, 42, 6, 11, 0))
    self.assertEqual(2, self.birthday.amountOfSecond())

  def testRebirth(self):
    self.birthday.time = time.mktime((2004, 1, 11, 14, 38, 42, 6, 11, 0))
    self.birthday.rebirth()
    self.assertEqual(time.mktime((2004, 1, 11, 14, 38, 44, 6, 11, 0)),
                     self.birthday.time)

  def tearDown(self):
    time.time = self.original_time

if __name__ == "__main__":
  unittest.main()
