from Globals import InitializeClass, DTMLFile
from App.ImageFile import ImageFile
from Acquisition import Implicit
from Globals import Persistent
from OFS.SimpleItem import Item
#from OFS.PropertyManager import PropertyManager
from AccessControl import ClassSecurityInfo
from MindMap import MindMap, MindMapRoot
from XML2MindMapRoot import XML2MindMapRoot

manage_addMindMapBBSForm=DTMLFile('dtml/add', globals())
def manage_addMindMapBBS(context, id, title, REQUEST=None):
  """ add function """
  p = MindMapBBS(id, title)
  context._setObject(id, p)
  if REQUEST is not None:
    context.manage_main(context, REQUEST)

class MindMapBBS(Implicit, Persistent, Item):
  meta_type = 'MindMapBBS'
  _properties = (
    {'id':'title',   'type':'string', 'mode':'w'},
  )
  security = ClassSecurityInfo()

  #security.declareProtected('MindMapBBS: Add pages', 'index_html')
  index_html = DTMLFile('dtml/index_html', globals())
  view = DTMLFile('dtml/view', globals())
  editForm = DTMLFile('dtml/edit', globals())
  triangle = DTMLFile('dtml/triangle', globals())
  mind_branch = DTMLFile('dtml/mind_branch', globals())
  mind_leaf = DTMLFile('dtml/mind_leaf', globals())
  mind_leaf_view = DTMLFile('dtml/mind_leaf_view', globals())
  mind_leaf_view_icons = DTMLFile('dtml/mind_leaf_view_icons', globals())
  mind_leaf_edit = DTMLFile('dtml/mind_leaf_edit', globals())
  mind_leaf_add = DTMLFile('dtml/mind_leaf_add', globals())

  xml = DTMLFile('dtml/xml', globals())
  xml_leaf = DTMLFile('dtml/xml_leaf', globals())

  manage_options = (
    {'label' : 'Edit', 'action' : 'editForm'},
    {'label' : 'View', 'action' : 'index_html'},
    )


  def __init__(self, id, title):
    """ init """
    self.id = id
    self.title = title
    self.root = MindMapRoot()
    self.root.add(None, 'root')
    self._p_changed = 1

  def __call__(self, client=None, REQUEST={}, RESPONSE=None, **kw):
    """ call from dtml var """
    return self.view.__call__(client, REQUEST, RESPONSE, kw)

  def root_message(self):
    return self.root.getRoot().getMessage()

  def manage_edit(self, title, xml_string, REQUEST=None):
    """ set project setting """
    self.title = title
    self.root = XML2MindMapRoot().createFromXML(xml_string)

    if REQUEST is not None:
      return self.editForm(REQUEST,
                           manage_tabs_message="Saved changes.")

  security.declareProtected('MindMapBBS: New MindMapBBS', 'action_newmmb')
  def action_newmmb(self, code, REQUEST=None):
    """ new MindMapBBS """
    return_url = self.createNewMMB(code)
    if REQUEST is not None:
      REQUEST.RESPONSE.redirect(return_url)

  security.declareProtected('MindMapBBS: Add', 'action_pre_add')
  def action_pre_add(self, code, mmb_url, return_url, REQUEST=None):
    """ pre add """
    childCode = code + '-child'
    return_url += '?code=' + childCode + '&mmb_url=' + mmb_url
    return_url += '#MMB' + mmb_url + '-' + childCode
    if REQUEST is not None:
      REQUEST.RESPONSE.redirect(return_url)

  security.declareProtected('MindMapBBS: Add', 'action_add')
  def action_add(self, code, mmb_url, return_url,
                 color, message, link, picture, REQUEST=None):
    """ add """
    child = self.root.add(code, '')
    self.root.change(child.getCode(), message, color, link, picture)
    self.editMMB(mmb_url, child.getCode(), return_url, REQUEST)

  security.declareProtected('MindMapBBS: Edit', 'action_pre_edit')
  def action_pre_edit(self, code, mmb_url, return_url, REQUEST=None):
    """ pre edit """
    return_url += '?code=' + code + '&mmb_url=' + mmb_url
    return_url += '#MMB' + mmb_url + '-' + code
    if REQUEST is not None:
      REQUEST.RESPONSE.redirect(return_url)

  security.declareProtected('MindMapBBS: Edit', 'action_edit')
  def action_edit(self, code, mmb_url, return_url,
                  color, message, link, picture, REQUEST=None):
    """ edit """
    self.root.change(code, message, color, link, picture)
    self.editMMB(mmb_url, code, return_url, REQUEST)

  security.declareProtected('MindMapBBS: Delete', 'action_remove')
  def action_remove(self, code, mmb_url, return_url, REQUEST=None):
    """ delete """
    parent = self.root.remove(code)
    if parent != None:
      self._p_changed = 1
      parentCode = parent.getCode()
    else:
      parentCode = self.root.getRoot().getCode()

    return_url += '#MMB' + mmb_url + '-' + parentCode

    if REQUEST is not None:
      REQUEST.RESPONSE.redirect(return_url)

  security.declareProtected('MindMapBBS: Forward Back', 'action_forward')
  def action_forward(self, code, mmb_url, return_url, REQUEST=None):
    """ forward """
    self.root.decode_map[code].moveForward()
    self.editMMB(mmb_url, code, return_url, REQUEST)

  security.declareProtected('MindMapBBS: Forward Back', 'action_back')
  def action_back(self, code, mmb_url, return_url, REQUEST=None):
    """ back """
    self.root.decode_map[code].moveBack()
    self.editMMB(mmb_url, code, return_url, REQUEST)

  security.declareProtected('MindMapBBS: Up Down', 'action_up')
  def action_up(self, code, mmb_url, return_url, REQUEST=None):
    """ up """
    self.root.decode_map[code].moveUp()
    self.editMMB(mmb_url, code, return_url, REQUEST)

  security.declareProtected('MindMapBBS: Up Down', 'action_down')
  def action_down(self, code, mmb_url, return_url, REQUEST=None):
    """ down """
    self.root.decode_map[code].moveDown()
    self.editMMB(mmb_url, code, return_url, REQUEST)

  def editMMB(self, mmb_url, code, return_url, REQUEST):
    self.refresh(self.root.getRoot())
    self._p_changed = 1
    if REQUEST is not None:
      REQUEST.RESPONSE.redirect(return_url + '#MMB' + mmb_url + '-' + code)


  def createNewMMB(self, code):
    folder = self.aq_parent
    nextKey = self.getNextKey(folder)
    to_mmb = MindMapBBS(nextKey, '')
    folder._setObject(nextKey, to_mmb)
    
    from_mm = self.root.decode_map[code]
    message = from_mm.getMessage()
    color = from_mm.getColor()
    to_mm = to_mmb.root.getRoot()
    to_mm.setMessage(message)
    to_mm.setColor(color)
    to_mm.setMmbLink(None)      
    to_mmb._p_changed = 1
    
    changed = self.mmbRefresh(self.root.getRoot())
    if changed:
      self._p_changed = 1

    return nextKey
    
    
  def getNextKey(self, folder):
    keys = self.getKeys(folder)
    key_number = 0
    while 1:
      key_string = 'mmb' + str(key_number)
      if not key_string in keys:
        return key_string
      key_number += 1
      
  def getKeys(self, folder):
    ids = folder.objectIds()
    keys = []
    for id in ids:
      keys.append(id)
    return keys

  def refresh(self, root):
    root.refresh()
    self.mmbRefresh(root)

  def mmbRefresh(self, root):
    root.refresh()
    folder = self.aq_parent
    items = folder.objectItems('MindMapBBS')
    map = {}
    for id, mmb in items:
      if id != self.id:
        map[mmb.root_message()] = id
    changed = root.mmbRefresh(map, root.getMessage())
    return changed

InitializeClass(MindMapBBS)
