#!/usr/local/bin/ruby -Ku
# encoding: UTF-8

#=全てのテストを実行するスクリプト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: run_all_tests.rb 3 2011-09-18 02:21:08Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

ROOT_PATH = File.dirname(File.expand_path(__FILE__))
$:.unshift(ROOT_PATH + "/")

require 'fileutils'
require 'run_all_tests_conf'

FileUtils.remove(Dir.glob(STDOUT_FILE))
FileUtils.remove(Dir.glob(STDERR_FILE))

result = 0

Dir::glob(TESTCODE_PATTERN).sort.each do |testcode|
	if !system("#{RUBY_COMMAND} #{testcode} -v >> #{STDOUT_FILE} 2>> #{STDERR_FILE}") then
		puts "Failed    ... #{testcode}"
		result = 1
	else
		puts "Successed ... #{testcode}"
	end
end

exit(result)
