#!/usr/local/bin/ruby -Ku
# encoding: UTF-8

#=テスト結果のサマリーを出力する CGI スクリプト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: view_testresult.cgi 3 2011-09-18 02:21:08Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

ROOT_PATH = File.dirname(File.expand_path(__FILE__))
$:.unshift(ROOT_PATH + "/")

require 'cgi'

require 'view_testresult_conf'

tests = {}

# 結果ファイルを解析する
if File.exist?(TESTRESULT_FILE_STDOUT) then
	open(TESTRESULT_FILE_STDOUT, 'r') do |file|
		while $line = file.gets
			if $line =~ /^([0-9a-zA-Z_]+)#(test[0-9a-zA-Z_]+) *[:=] *([0-9]+\.[0-9]+) *s *[:=] *(.)$/ then
				test_cls = $1
				test_method = $2
				test_sec = $3
				test_result = $4

				if !tests.has_key?(test_cls) then
					tests[test_cls] = {}
				end

				if !tests[test_cls].has_key?(test_method) then
					tests[test_cls][test_method] = {}
				end

				tests[test_cls][test_method]['sec'] = test_sec
				tests[test_cls][test_method]['result'] = test_result
			end
		end
	end
end

# 結果を html で出力する
cgi = CGI.new("html4")
cgi.out() do
	cgi.html() do
		cgi.head() do
			cgi.title{HTML_TITLE} +
			"<META http-equiv='Content-Type' content='text/html; charset=UTF-8' />" +
			((CSS_URL != nil) ? "<LINK rel='stylesheet' href='#{CSS_URL}' type='text/css' />" : '')
		end +
		cgi.body() do
			body = "<h1>#{HTML_TITLE}</h1>"

			# 概要を出力する
			body << "<h2>#{SUMMARY_TITLE}</h2>"

			body << "<table>"
			body << "<tr><th>#{TABLE_COLUMN_LABEL_TEST_CLASS}</th><th>#{TABLE_COLUMN_LABEL_SUCCESSED_COUNT}</th><th>#{TABLE_COLUMN_LABEL_FAILED_COUNT}</th></tr>"
			tests.keys.sort.each do |test_cls|
				success_count = 0
				fail_count = 0
				body << "<tr>"
				tests[test_cls].keys.each do |test_method|
					if tests[test_cls][test_method]['result'] == '.' then
						success_count = success_count + 1
					else
						fail_count = fail_count + 1
					end
				end
				body << "<td>#{test_cls}</td><td>#{success_count}</td><td>#{fail_count}</td>"
				body << "<tr>"
			end
			body << "</table>"

			# 詳細を出力する
			body << "<h2>#{DETAIL_TITLE}</h2>"

			body << "<table>"
			body << "<tr><th>#{TABLE_COLUMN_LABEL_TEST_CLASS}</th><th>#{TABLE_COLUMN_LABEL_TEST_METHOD}</th><th>#{TABLE_COLUMN_LABEL_SEC}</th><th>#{TABLE_COLUMN_LABEL_RESULT}</th></tr>"
			tests.keys.sort.each do |test_cls|
				method_index = 0
				tests[test_cls].keys.sort.each do |test_method|
					body << "<tr>"
					if method_index == 0 then
						body << "<td rowspan='#{tests[test_cls].size}'>#{test_cls}</td>"
					end

					body << "<td>#{test_method}</td><td>#{tests[test_cls][test_method]['sec']}</td>"

					if tests[test_cls][test_method]['result'] == '.' then
						body << "<td>#{RESULT_LABEL_SUCCESED}</td>"
					else
						body << "<td>#{RESULT_LABEL_FAILED}</td>"
					end
					body << "</tr>"

					method_index = method_index + 1
				end
			end
			body << "</table>"

			body
		end
	end
end
