#!ruby
# encoding: UTF-8

#=全てのテストを実行するスクリプト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: run_all_tests.rb 13 2011-11-24 12:33:35Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

ROOT_PATH = File.dirname(File.expand_path(__FILE__))
$:.unshift(ROOT_PATH + "/")

require 'fileutils'
require 'run_all_tests_conf'

FileUtils.remove(Dir.glob(STDOUT_FILE))
FileUtils.remove(Dir.glob(STDERR_FILE))

result = true

open(STDOUT_FILE, "w") do |file|
	file.write("#{SYSTEM_OUTPUT_PREFIX}Start running tests ... [#{Time.now.strftime(TIME_FORMAT)}]\n")
end

Dir::glob(TESTCODE_PATTERN).sort.each do |testcode|
	open(STDOUT_FILE, "a") do |file|
		file.write("#{SYSTEM_OUTPUT_PREFIX}Start running #{File.basename(testcode)} tests ...\n")
	end
	if !system("#{RUBY_COMMAND} #{testcode} -v >> #{STDOUT_FILE} 2>> #{STDERR_FILE}") then
		puts "Failed    ... #{testcode}"
		result = false
	else
		puts "Successed ... #{testcode}"
	end
end

open(STDOUT_FILE, "a") do |file|
	file.write("#{SYSTEM_OUTPUT_PREFIX}Finish running tests ... [#{Time.now.strftime(TIME_FORMAT)}]\n")
end

exit(result)
