/****************************************************************/
/*								*/
/*	ic.h							*/
/*								*/
/*		Definitions for the "Integer Calculator".	*/
/*								*/
/****************************************************************/
/*  origination         1988-Apr-6         Terrence W. Holm	*/
/****************************************************************/

/****************************************************************/
/*								*/
/*	ic(1)							*/
/*								*/
/* This is a simple RPN calculator, used for small calculations */
/* and base conversions. All calculations are done using 32 bit */
/* integers.							*/
/*								*/
/* Commands are available for stack operations, saving results, */
/* arithmetic and logical operations, and escaping to the Minix */
/* shell.							*/
/*								*/
/* The program requires termcap(3), but otherwise should run	*/
/* under all Unix (tm) variants.				*/
/*								*/
/* See the ic(1) man page.					*/
/*								*/
/****************************************************************/

/****************************************************************/
/*								*/
/*	ic 		   Copyright  Terrence W. Holm  1988	*/
/*								*/
/* This program was written for users of the Minix operating	*/
/* system, and in the spirit of other public domain software	*/
/* written for said system, this source code is made available	*/
/* at no cost to everyone.					*/
/*								*/
/* This program (one .h, three .c and a "man" page) may be	*/
/* copied and/or modified subject to (1) no charge must be	*/
/* made for distribution, other than for the medium, (2) all	*/
/* modified sources must be clearly marked as such, (3) all	*/
/* sources must carry this copyright.				*/
/*								*/
/****************************************************************/

/****************************************************************/
/*								*/
/*	files							*/
/*								*/
/*	    ic.h		Definitions			*/
/*	    ic.c		The main loop			*/
/*	    ic_input.c		Character input routines	*/
/*	    ic_output.c		Output routines			*/
/*								*/
/*	    ic.1		"Man" page			*/
/*	    Makefile		For "make"			*/
/*								*/
/****************************************************************/

#define   UNS(x)	((unsigned long)(x))
#define   STACK_SIZE 	6		/*  Max # of levels	*/
#define   REGISTERS	10		/*  Registers 0 to 9	*/
#define	  LAST_WAS_ENTER    1		/*  Numeric input modes	*/
#define	  LAST_WAS_NUMERIC  2
#define	  LAST_WAS_FUNCTION 3
#define   ASCII		-1		/*  Input and output	*/
#define   BINARY  	2		/*  modes		*/
#define   OCTAL		8
#define	  DECIMAL	10
#define   HEXADECIMAL	16
#define   OK		0		/*  Return codes	*/
#define   ERROR		1

#define   CTRL_D	'\004'		/*  ASCII ^D		*/
#define   BELL		'\007'		/*  ASCII bell code     */
#define   BS		'\010'		/*  ASCII back space	*/
#define	  ESCAPE  	'\033'		/*  ASCII escape code	*/
#define   DEL           '\177'		/*  ASCII delete code   */

/*  Input escape codes generated by the	Minix console.	*/
/*  Format: ESC [ X. Shows character equivalent for ic.	*/
#define   ESC_HOME	'H' + 0x80  	/*   z			*/
#define   ESC_UP	'A' + 0x80  	/*   x			*/
#define   ESC_PGUP	'V' + 0x80	/*   w			*/
#define   ESC_LEFT	'D' + 0x80	/*   r			*/
#define   ESC_5		'G' + 0x80	/*   %                  */
#define   ESC_RIGHT	'C' + 0x80	/*   s			*/
#define   ESC_END	'Y' + 0x80	/*   q			*/
#define   ESC_DOWN	'B' + 0x80	/*   p			*/
#define   ESC_PGDN	'U' + 0x80	/*   l			*/
#define   ESC_PLUS	'T' + 0x80	/*   +			*/
#define   ESC_MINUS	'S' + 0x80	/*   -			*/

/*  Move positions for the output display.		*/
#define   STACK_COLUMN	4
#define   STACK_LINE	7
#define   REG_COLUMN	STACK_COLUMN+36
#define   REG_LINE	3
#define   STATUS_COLUMN	6
#define   STATUS_LINE   0
#define   WAIT_COLUMN   0
#define   WAIT_LINE     14

typedef  struct  ic_state		/*  State of int. calc.	*/
{
  long int stack[ STACK_SIZE ];		/*  The stack		*/
  long int registers[ REGISTERS ];	/*  The registers	*/
  int  stack_size;			/*  Current size (>= 1)	*/
  int  register_mask;			/*  In use bit mask	*/
  long int last_tos;			/*  For 'L' command	*/
  int  mode;				/*  Last key type. See	*/
					/*  LAST_WAS_ENTER, etc	*/
  int  input_base;			/*  Current i/o base,	*/
  int  output_base;			/*  ASCII, BINARY, etc	*/
  
  FILE *scratch_pad;			/*  For 'w' command	*/
  char  file_name[20];			/*  "pad" or "/tmp/pad"	*/
} ic_state;

/* ic.c */
_PROTOTYPE(int main, (int argc, char *argv []));
_PROTOTYPE(void Init_State, (ic_state *s ));
_PROTOTYPE(void Sigint, (int sig ));
_PROTOTYPE(int Process, (ic_state *s, int c ));
_PROTOTYPE(int Enter_Numeric, (ic_state *s, int numeral ));
_PROTOTYPE(void Push, (ic_state *s ));
_PROTOTYPE(void Pop, (ic_state *s ));
_PROTOTYPE(void Exec_Shell, (void));

/* ic_input.c */
_PROTOTYPE(void Save_Term, (void));
_PROTOTYPE(void Set_Term, (void));
_PROTOTYPE(void Reset_Term, (void));
_PROTOTYPE(int Get_Char, (void));
_PROTOTYPE(void Init_Getc, (int argc, char *argv []));
_PROTOTYPE(int Getc, (void));
_PROTOTYPE(int Get_Base, (int code ));

/* ic_output.c */
_PROTOTYPE(int Init_Termcap, (void));
_PROTOTYPE(void Move, (int column, int line ));
_PROTOTYPE(void Puts, (char *string ));
_PROTOTYPE(void Putchar, (int c ));
_PROTOTYPE(void Draw_Help_Screen, (void));
_PROTOTYPE(void Draw_Prompt, (char *string ));
_PROTOTYPE(void Erase_Prompt, (void));
_PROTOTYPE(void Draw_Screen, (ic_state *s ));
_PROTOTYPE(void Draw_Stack, (ic_state *s ));
_PROTOTYPE(void Draw_Registers, (ic_state *s ));
_PROTOTYPE(void Draw_Top_of_Stack, (ic_state *s ));
_PROTOTYPE(void Print_Number, (FILE *stream, long int numb, int output_base ));
