﻿var currentDoc = app.activeDocument;
var newFileName = currentDoc.name.substring(0, currentDoc.name.lastIndexOf('.')) + '.svg';
var newDirName = currentDoc.path.toString().replace('/mplus', '/rounded');

var newDir = new Folder(newDirName);
if(! newDir.exists){ newDir.create();}

var newFile= new File(newDirName + '/' + newFileName);
if (newFile.open('w')){
    newFile.close();
}else{
    throw new Error('Access is denied');
}

var options = new ExportOptionsSVG();
options.DTD = SVGDTDVersion.SVG1_0;
options.documentEncoding = SVGDocumentEncoding.UTF8;
options.cssProperties = SVGCSSPropertyLocation.PRESENTATIONATTRIBUTES;
options.embedRasterImages = false;
options.includeFileInfo = false;
currentDoc.exportFile(newFile, ExportType.SVG, options);