// -*- mode: c++ -*-

#ifndef MiX_TEXT_H_
#define MiX_TEXT_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"
#include "NodeList.h"
#include "extern/noncopyable.hpp"

namespace MiX{
  template <class charT,class char_traits,class xml_traits>
  class Text : boost::noncopyable,
	       public Value<charT,char_traits,xml_traits>{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef Text<charT,char_traits,xml_traits> this_type;
    typedef NodeContainer<charT,char_traits,xml_traits> nodecontainer_type;
    typedef typename nodelist_type::iterator nodelist_iter; 
  protected:
    const static typename NodeList<charT,char_traits,xml_traits>::iterator dmy_it;
    /**
     * RXgN^
     *
     * Text̃RXgN^͒ڌĂׂ܂<br>
     * Text<...>::createŐĂ
     */
    Text(const string_type& val) : Value<charT,char_traits,xml_traits>(val){ };
  public:
    ///fXgN^
    virtual ~Text()throw(){ };
    ///̃m[h̃^Cv𓾂܂
    virtual NodeType getType()const{ return Node_Text; };
    /**
     * ÓIɃNXNodeType𓾂܂
     *
     * Node_TextԂ܂
     */
    static NodeType type(){ return Node_Text; };
    /**
     * Text̕\𓾂܂
     *
     * bIndent^Ȃ當iIndentOffsetɎw肳ꂽ
     * XMLTraits::tab()߂l̐擪ɂ܂B
     */
    virtual string_type toString(bool indent=false,int indent_off=0)const;
    /**
     * Text𕡐܂
     *
     *  \param parent ̐em[h
     *  \param it }ꏊ(parent.getChilds()̗vfCe[^łȂĂ͂Ȃ܂)
     */
    node_type& clone(nodecontainer_type& parent,const nodelist_iter& it = dmy_it) const 
      { return create(getValue(),dynamic_cast<element_type&>(parent),it); }

    /**
     * Text𐶐܂
     *
     * \param str Text̒l
     * \param parent Text̐eGg
     * \param it }ꏊ(parent.getChilds()̗vfCe[^łȂ΂Ȃ܂)
     */
    static this_type& create(const string_type& str,element_type& parent,const typename nodelist_type::iterator& it = dmy_it);

    friend class DOM_Parser<charT,char_traits,xml_traits>;
  };
}

#ifndef MiX_TEXT_CPP_
#include "Text.cpp"
#endif

#endif
