//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include "../src/MiX/DOM_Parser.h"
#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"

#define T(str) MiX::XMLString<char>( str )

//CUPPA:namespace=+
//CUPPA:namespace=-

class DOM_ParserTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(DOM_ParserTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testParseBuffer);
  CPPUNIT_TEST(testParseStream);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
  static const char data_[];

  void testImpl(MiX::Document<char>& doc){
    CPPUNIT_ASSERT_EQUAL( T("1.0"), doc["version"].getValue() );
    CPPUNIT_ASSERT_EQUAL( T("UTF-8"), doc["encoding"].getValue() );
    CPPUNIT_ASSERT_EQUAL( T("TestSuite"), doc.getRoot().getName() );
    CPPUNIT_ASSERT_EQUAL( T("DOM_ParserTest"), 
			  doc.getRoot()["name"].getValue());
    CPPUNIT_ASSERT_EQUAL( T("TestCase"),doc.getRoot()("TestCase").getName() );
    CPPUNIT_ASSERT_EQUAL( T("testParse"),
			 doc.getRoot()("TestCase")["name"].getValue() );
    CPPUNIT_ASSERT_EQUAL( T("This \nis \ntest \ntext."),
			  doc.getRoot().getText() );
    CPPUNIT_ASSERT_EQUAL( T(data_), doc.toString());
  }

public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void testParseBuffer() {
    MiX::DOM_Parser<char> parser;
    MiX::Document<char>& doc = parser.parse(data_);
    testImpl(doc);
  }
  void testParseStream() {
    std::istringstream ss(data_);
    MiX::DOM_Parser<char> parser;
    MiX::Document<char>& doc = parser.parse(ss);
    testImpl(doc);
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

const char DOM_ParserTest::data_[] = {
  "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
  "<!-- -->"
  "<TestSuite name=\"DOM_ParserTest\">"
  "<!-- This is test comment. -->"
  "<TestCase name=\"testParse\"/>"
  "This \nis \ntest \ntext."
  "</TestSuite>"
};


CPPUNIT_TEST_SUITE_REGISTRATION(DOM_ParserTest);
