//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"

//CUPPA:namespace=+
//CUPPA:namespace=-

class DocumentTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(DocumentTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testCreate);
  CPPUNIT_TEST(testString);
  CPPUNIT_TEST(testClone);
  CPPUNIT_TEST(testOtherOp);
  CPPUNIT_TEST(testDestroy);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
  static MiX::Document<char>* doc_;
public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void testCreate() {
    //[hLg
    // <?xml version="1.0" encoding="UTF-8"?>
    // <TestSuite name="DocumentTest">
    // <TestCase name="testCreate"/>
    // <TestCase name="testString"/>
    // <Description>This is test for MiX::Document</Description>
    // </TestSuite>
    doc_ = &(MiX::Document<char>::create("TestSuite"));
    CPPUNIT_ASSERT_EQUAL(doc_->getType(),MiX::Node_Document);
    MiX::Attribute<char>::create("version","1.0",*doc_);
    MiX::Attribute<char>::create("encoding","UTF-8",*doc_);
    MiX::Element<char>& el = doc_->getRoot();
    MiX::Attribute<char>::create("name","DocumentTest",el);
    MiX::Attribute<char>::create("name","testCreate",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Attribute<char>::create("name","testString",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Text<char>::create("This is test for MiX::Document",
			    MiX::Element<char>::create("Description",el));
  }
  void testString() {
    const char data[] = {
      "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
      "<TestSuite name=\"DocumentTest\">"
      "<TestCase name=\"testCreate\"/>"
      "<TestCase name=\"testString\"/>"
      "<Description>This is test for MiX::Document</Description>"
      "</TestSuite>"
    };
    CPPUNIT_ASSERT(doc_->toString()==data);
  }
  void testClone() {
    MiX::Node<char>& doc = doc_->clone();
    CPPUNIT_ASSERT_EQUAL(doc_->toString(),doc.toString());
  }
  void testOtherOp() {
    CPPUNIT_ASSERT((*doc_)["version"].getValue()=="1.0");
    CPPUNIT_ASSERT((*doc_)["encoding"].getValue()=="UTF-8");
    MiX::NodeList<char> lst = doc_->getElementsByTagName("TestCase");
    CPPUNIT_ASSERT_EQUAL(2,(int)lst.size());
    MiX::NodeList<char>::iterator it = lst.begin();
    MiX::NodeList<char>::iterator last = lst.end();
    for( ; it != last ; ++it ){
      CPPUNIT_ASSERT_EQUAL(MiX::Node_Element,(*it)->getType());
      MiX::Element<char>& el = dynamic_cast<MiX::Element<char>&>(**it);
      CPPUNIT_ASSERT(el.getName()=="TestCase");
    }
  }
  void testDestroy() {
    doc_->destroy();
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
MiX::Document<char>* DocumentTest::doc_ = 0;
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(DocumentTest);
