//: <html>
//: <head><title>SoupProject::MiX::sample::xml2html</title>
//: <link rel="stylesheet" href="../default.css" type="text/css"/></head>
//: <body>
//: <h2>xml2html</h2>
//: <p>xmlե򿩤碌Ƥ򥰥եɽHTMLե
//: Ǥץޤ<br>
//: ɤsamples/xml2html/ˤޤ<br>
//: ͤˡɥȤƾSAXѤ
//: ץ˥ץ뤳ȤǤޤ
//: </p>
//: <h2>٥ȥϥɥμ</h2>
//: <p>ޤinclude٤ΤǤ</p>
//: <pre>
#include <iostream>

#include <MiX/SAX_Parser.h>
#include <MiX/SAX_EventHandler.h>
//: </pre>
//: <p>iostreamOKȤơMiX/SAX_ParserSAXѡإåǡ
//: SAX_EventHandlerSAXѡΤ륤٥Ȥ뤿
//: ϥɥδ쥯饹Ƥޤ<br>
//: SAXǤϥ٥Ȥ뤳ȤˤäXMLɤ߹ǤΤǡ
//: ٥ȥϥɥ򵭽Ҥɬפޤ</p>
//: <pre>
class EventHandler : public MiX::SAX_EventHandler<char>{
  int indent_;
  std::ostream& out_;
public:
  EventHandler(std::ostream& out) : out_(out){
    indent_ = 0;
  }
//: </pre>
//: <p>SAX_EventHandler(˸¤餺ؤɤMiXΥ饹)ϥƥץ졼ȥ饹ǡ
//: ʸʸξXML˴ؤ3ĤΥѥ᡼ޤ<br>
//: ʸꤹСϤ٤ƥǥեͤŬѤޤ
//: ̤ۤʤȤ򤷤ʤ¤ꡢǥեȤǽʬǤ礦<br><br>
//: ޤ&lt;? xml ..... ?&gt;ɤߤȤäȤΤ륤٥Ȥ
//: ϥɥ餫鵭Ҥޤ</p><pre>
  virtual void onXMLDeclaration(MiX::AttrMap<char> attr){
    out_ << "<html>" << std::endl
	 << "<head><title>xml2html</title></head>" 
	 << std::endl << "<body>" << std::endl;
  }
//: </pre><p>ǤHTMLΥإåϤƤޤ
//: version°ʤɤɤߤȤꤿϡattr˳ǼƤΤǡ
//: attr["version"]ʤɤȤ뤳ȤǡǤޤ<br>
//: AttrMapstd::map<string_type,string_type>ȤۤʤΤ
//: ܺ٤STLˤĤĴ٤Ƥ<br><br>
//: ϳϥɤߤȤäΤ륤٥ȤΥϥɥ򵭽Ҥޤ
//: </p><pre>
  virtual void onStart(MiX::XMLString<char> name,MiX::AttrMap<char> attr){
    out_ << "<div style=\"margin-left:" << 40*indent_
	 << "px\">" << "<b>&lt;" << name << "</b>" << std::endl;
    MiX::AttrMap<char>::iterator it = attr.begin();
    for( ;it!=attr.end();it++){
      out_ << " " << it->first 
	   << " = <span style=\"color: #000055;\">\'" 
	   << it->second << "\'</span>" << std::endl;
    }
    out_ << "<b>&gt;</b>" << std::flush;
    out_ << "</div>" << std::endl;
    ++indent_;
  }
//: </pre><p>
//: onStartΰΰ̣</p>
//: <DL>
//: <DT>name</DT>
//: <DD>̾</DD>
//: <DT>attr</DT>
//: <DD>λĥȥӥ塼ȤǼ</DD>
//: </DL><p>
//: Ǥ<br>
//: Ǥϡ̾°򤹤٤ƽϤ塢indent_äƤޤ<br>
//: <br>ϡλɤߤȤäΥϥɥǤ
//: </p><pre>
  virtual void onEnd(MiX::XMLString<char> name){
    indent_--;
    out_ << "<div style=\"margin-left:" << 40*indent_
	 << "px\">" << "<b>&lt;/" << name << "&gt;</b>" 
	 << "</div>";
    if(indent_==0){
      out_ << "</body></html>" << std::endl;
    }
  }
//: </pre><p>
//: λɤߤȤäϡǥȤ򸺤餷̾ϤƤޤ<br>
//: ޤindent_0ˤʤä顢XMLΥѡ󥰤λȤߤʤ
//: HTMLΥեåϤޤ<br><br>
//: ĤˡXMLʸʸɤߤȤäΥϥɥȡ
//: ȤɤߤȤäΥϥɥ򵭽Ҥޤ
//:</p><pre>
  virtual void onText(MiX::XMLString<char> text){
    out_ << "<div style=\"margin-left:" << 40*indent_
	 << "px\">" << text << "</div>" << std::endl;
  }
  virtual void onComment(MiX::XMLString<char> text){
    out_ << "<div style=\"margin-left:" << 40*indent_
	 << "px\">" << "<span style=\"color: #777777;\">" 
	 << "&lt;!-" << text << "--&gt;" 
	 << "</span>" << "</div>" << std::endl;
  }
};
//: </pre><p>
//: onTextȡonCommentindent_˽ä
//: ǥȤ򤷤ǡϤƤǤ<br><br>
//: ǥ٥ȥϥɥμϽޤ<br>
//: ǤۤȤƴƤޤ<br>
//: Ǹ˥٥ȤȯԤޤǤνmain˵Ҥޤ
//: <h2>mainμ</h2>
//: <p>
//: mainǤ٤Ȥϥѡȡѡ󥰤γϤǤ
//: </p><pre>
int main(int argc,char* argv[]){
  try{
    MiX::SAX_Parser<char> parser;
    EventHandler handler(std::cout);
    parser.setIgnoreSpace(true);
    parser.setEventHandler(&handler);
    parser.parse(std::cin);
    return 0;
//: </pre><p>ѡȡäEventHandlerΥ󥹥󥹤
//: setEventHandlerĤӤĤơparseƤޤ<br>
//: setIgnoreSpaceϡXMLʸΰ̣ʤʶʸ̵뤹
//: Ƥޤ<br>
//: ְ̣ʤפäƤΤϥѡȽǤΤǡ̩ʽɬ
//: ˤʤϡꤷʤۤɤǤ
//: </p><pre>
  }catch(MiX::ParsingException& e){
    std::cerr << e.what() << std::endl;
    return -1;
  }
}
//:</pre><p>
//: Ǹˡѡ˥顼äcatch֥å񤭤ޤ<br>
//: Ǥϡ顼ʸɽǤ<br>
//: <br>
//: äȸܤɤHTMLǤץ(ñ)񤱤顢
//: MiX-MLꤲƤȡ򤷤Ǥ
//: </p></body></html>
