//: <html>
//: <head><title>SoupProject::MiX::sample::xmlpb</title>
//: <link rel="stylesheet" href="../default.css" type="text/css"/></head>
//: <body>
//: <h1>SoupProject::MiX</h1>
//: <h2>db - DOMɂ</h2>
//: <p>
//: dbDOMpĎĂ݂܂傤B<br>
//: db̂悤ȃXg̃f[^ꍇSAX̂قyǁA
//: DOMɂ̈ƂāAČ܂B
//: </p><pre>
#include <MiX/MiX.h>

#include <iostream>
#include <fstream>
#include <string>
#include <utility>
//: </pre><p>
//: ܂Kvȃwb_CN[h܂B<br>
//: MiX/MiX.hMiX̑St@Cinclude܂BRpCxȂ܂A
//: DOMgpꍇAC`C`includê͑ʓ|Ȃ̂ŁA
//: ̂悤ɂĂǂƎv܂B
//: </p><pre>
typedef MiX::Element<char> Person;
typedef std::map<std::string,Person*> Index;
//: </pre><p>
//: db̗vf\Person^ƁAdb̍\Index^`܂B
//: </p><pre>
class PhoneBook {
  MiX::Document<char>& doc_;
  Index index_;
  MiX::Document<char>& loadDocument(std::string fname){
    std::ifstream fin(fname.c_str());
    if(!fin){
      MiX::Document<char>& ret = MiX::Document<char>::create("PhoneBook");
      MiX::Attribute<char>::create("version","1.0",ret);
      MiX::Attribute<char>::create("encoding","UTF-8",ret);
      return ret;
    }else{
      MiX::DOM_Parser<char> parser;
      parser.setIgnoreSpace(true);
      return *parser.parse(fin);
    }
  }
//: </pre><p>
//: loadDocument\bh̓t@C^
//: t@CǂݍDOMp[TɂāADOMDocumentIuWFNgԂ܂B
//: t@C݂ȂꍇA ̃hLgĂԂ܂B<br>
//: DOMParser<...>::setIgnoreSpace(bool)XMLɌXy[X^uA
//: s𖳎邩ǂݒ肷郁\bhłB<br>
//: PȂ镶`̂߂Ƀ^usgĂꍇAݒ肷Ƃ
//: p[WOɂ̋󔒂𖳎Ă邽ߏƂĂȒPɂȂ܂B
//: A󔒂Ӗp[WOꍇ͎gĂ͂܂B<br>
//: ͐qdoc_邽߂̃\bhłB
//: </p><pre>
  Index loadIndex(MiX::Document<char>& doc){
    Index ret;
    MiX::NodeList<char>::iterator it = doc.getRoot().getChildren().begin();
    MiX::NodeList<char>::iterator last = doc.getRoot().getChildren().end();    
    for( ;it!=last;++it){
      if((*it)->getType()==MiX::Node_Element){
	Person* p = dynamic_cast<Person*>(*it);
	ret.insert(std::make_pair((*p)("Name").getText(),p));
	std::cout << (*p)("Name").getText() << " Loaded." << std::endl;
      }
    }
    return ret;
  }
//: </pre><p>
//: loadIndex\bhDocumentIuWFNg^ƁA
//: 𐶐Ă܂B<br>
//: gindex_܂B<br>
//: doc.getRoot()ŃhLg̃[gm[h𓾂āA
//: ̃m[hgetChildrenŎqm[h̃Xg𓾂Ă܂B<br>
//: āACe[^pđSĂ̎qElementɑ΂āA
//: OƂElementgւ̃|C^index_ɓo^Ă܂B
//: ō̂łłB
//: </p><pre>
public:
  PhoneBook(std::string fname)
    : doc_(loadDocument(fname)),index_(loadIndex(doc_)){ }
//: </pre><p>
//: RXgN^łB<br>
//: t@CloadDocumentloadIndexĂ g𐶐܂B 
//: </p><pre>
  void store(std::string fname){
    std::ofstream fout(fname.c_str());
    fout << doc_.toString(true) << std::endl;
    fout.close();
  }
//: </pre><p>
//: store\bh̓t@CɎgۑ邽߂̃\bhłB<br>
//: DOMIuWFNĝ܂܂Ă̂ŁA
//: i[͂DOMIuWFNg𕶎񉻂ďނłB
//: toString̈̓CfgsۂłB 
//: </p><pre>
  void addPerson(std::string name,std::string phone){
    MiX::Element<char>& e=MiX::Element<char>::create("Person",doc_.getRoot());
    MiX::Element<char>& n=MiX::Element<char>::create("Name",e);
    MiX::Element<char>& p=MiX::Element<char>::create("Phone",e);
    n.setText(name);
    p.setText(phone);
    index_.insert(std::make_pair(name,&e));
  }
//: </pre><p>
//: addPerson͓dbɐVȐlǉ邽߂̃\bhłB<br>
//: doc_ɐVl\GgǉA
//: index_ɒǉf[^o^Ă܂B 
//: </p><pre>
  Index& getIndex(){
    return index_;
  }
};
//: </pre><p>
//: getIndexindex_getterłB<br>
//: ȏPhoneBookNX͏IłB<br>
//: Ƃ͂܂܂ƂĂ܂B <br>
//: </p><pre>
void outputPerson(std::ostream& os,Person& p){
  os << p("Name").getText() << " : " << p("Phone").getText() << std::endl;
}
//: </pre><p>
//: outputPersonPersono̓Xg[ɏo͂֐łB
//: </p><pre>
std::string input(const char* prompt){
  std::string ret;
  std::cout << prompt << ": " << std::flush;
  std::cin >> ret;
  return ret;
}
//: </pre><p>
//: input͎w肳ꂽ\A[U̓͂󂯎֐łB<br>
//: BASICINPUTƈꏏłB<br><br>
//: Ōmain֐łB
//: </p><pre>
int main(){
  PhoneBook pb("phonebook.xml");

  char cmd = '\0';
  while(cmd!='q'){
    cmd = input("add/delete/find/list/clear/quit [a,d,f,l,c,q]").at(0);
    switch(cmd){
    case 'a' : case 'A' : {
      std::string name = input("Name");
      Index::iterator it = pb.getIndex().find(name);
      if(it!=pb.getIndex().end()) 
	std::cerr << "error: already exists." << std::endl;
      else {
	std::string phone = input("Phone");
	pb.addPerson(name,phone);
      }
      break;
    }
//: </pre><p>
//: 'a'͂ꂽAIndexp͂ꂽOɑ݂ȂƂmFāA
//: addPersonŒǉ܂B
//: </p><pre>
    case 'd' : case 'D' : {
      std::string name = input("Name");
      Index::iterator it  =pb.getIndex().find(name);   
      if(it==pb.getIndex().end()){
	std::cerr << "error: not found!" << std::endl;
      }else{
	pb.getIndex().erase(it);
	it->second->destroy();
      }
      break;
    }
//: </pre><p>
//: 'd'͂ꂽAIndexp͂ꂽOɑGg𓾂āA
//: destroy\bhŏ܂B
//: </p><pre>
    case 'f' : case 'F' : {
      std::string name = input("Name");
      Index::iterator it=pb.getIndex().find(name);
      if(it!=pb.getIndex().end()) 
	outputPerson(std::cout,*(it->second));
      else std::cerr << "error: not found." << std::endl;
      break;
    }
//: </pre><p>
//: 'f'͂ꂽAIndexp͂ꂽOɑGg𓾂āA
//: outputPersonŏo͂܂B
//: </p><pre>
    case 'l' : case 'L' : {
      std::cout << pb.getIndex().size() <<"entries:" << std::endl;
      Index::iterator it = pb.getIndex().begin();
      Index::iterator last = pb.getIndex().end();
      for( ;it!=last;++it) outputPerson(std::cout,*(it->second));
      break;
    }
//: </pre><p>
//: 'l'͂ꂽAIndexԂɑAׂẴGg
//: outputPersonŏo͂܂B
//: </p><pre>
    case 'c' : case 'C' : {
      while( !pb.getIndex().empty() ){
	Index::iterator it = pb.getIndex().begin();
	pb.getIndex().erase(it);
	it->second->destroy();
      }
      break;
    }
//: </pre><p>
//: 'c'͂ꂽAIndexԂɑAׂẴGg
//: destroyŏAIndexĂ܂B
//: </p><pre>
    // I
    case 'q' : case 'Q' : 
    default :
      break;
    }
  }
  pb.store("phonebook.xml");
}
//: </pre><p>
//: 'q'͂ꂽAI܂
//: IOɃf[^t@Cɕۑ܂B
//: </p><pre>
