#define MIX_TOKENIZER_CPP_

#include "Tokenizer.h"
#include "DefaultTraits.h"
#include "DefaultXMLTraits.h"
#include "XMLToken.h"
#include <algorithm>

namespace MiX{

  //g[N
  template<class charT,class char_traits,class xml_traits>
  const charT Tokenizer<charT,char_traits,xml_traits>::tokens_[TokenCount] = {
    xml_traits::null(),
    xml_traits::cr(),
    xml_traits::lf(),
    xml_traits::sp(),
    xml_traits::tab(),
    xml_traits::lt(),
    xml_traits::eq(),
    xml_traits::gt(),
    xml_traits::slash(),
    xml_traits::hyphen(),
    xml_traits::semicolon(),
    xml_traits::exclamation(),
    xml_traits::question(),
    xml_traits::amp(),
    xml_traits::dblquote(),
    xml_traits::quote(), 
    xml_traits::lsb(),
    xml_traits::rsb()
  };

  template <class charT,class char_traits,class xml_traits>
  bool Tokenizer<charT,char_traits,xml_traits>::fillUpBuffer(){
    if (is_ && !is_->eof() ) {
      std::string buf;
      charT c = xml_traits::null();
      do {
	is_->read( &c,sizeof(charT) );
	buf+=c;
      } while( c!=xml_traits::gt() && !is_->eof() );
      if( buf.empty() ) return false;
      if(buf_) delete buf_;
      buf_ = new charT[buf.size()+1];  buf_[buf.size()]=xml_traits::null();
      std::copy(buf.begin(),buf.end(),buf_);
      return injectString(buf_);
    } else {
      return false;
    }
  }
  
  template <class charT,class char_traits,class xml_traits>
  bool Tokenizer<charT,char_traits,xml_traits>::ejectToken(XMLToken<charT,char_traits,xml_traits>& dest){
    //X^bNɋlߍ܂ꂽg[NcĂ΁AoB
    if(!stack_.empty()){
      dest = stack_.top();
      stack_.pop();
      return true;
    }
    
    while(*current_==xml_traits::null()){
      if(!fillUpBuffer()){
	token_type tok(current_,current_+1,Token_null,current_-start_);
	dest = tok;
	return false;
      }
    }
    TokenType type;
    if(Token_text!=(type=isToken(*current_))){
      token_type tok(current_,current_+1,type,current_-start_);
      current_++;
      dest = tok;
      return true;
    }
    const charT* mark = current_;
    while(Token_text==isToken(*(current_+1))){
      current_++;
    }
    long size = current_-mark+1;
    token_type tok(mark,mark+size,Token_text,mark-start_);

    current_++;
    dest = tok;
    return true;
  }
    
  template<class charT,class char_traits,class xml_traits>
  TokenType Tokenizer<charT,char_traits,xml_traits>::isToken(charT c){
    for(int i=0;i<TokenCount;++i)
      if(tokens_[i]==c) return static_cast<TokenType>(i);
    return Token_text;
  }
}
