//CUPPA:include=+
#include "../src/MiX/MiX.h"
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

class KnownBugTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(KnownBugTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test825);
  CPPUNIT_TEST(test824);
  CPPUNIT_TEST(test784);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void test825() {
    std::istringstream ss;
    MiX::DOM_Parser<char> parser;
    MiX::Document<char>* doc = parser.parse(ss);
    delete doc;
  }

  void test824() {
    const char data[] = {
      "<?xml?>"
      "<TestRoot xmlns=\"url_default\" xmlns:html=\"url_for_html\">"
      "<TestElement xmlns:rdf=\"url_for_rdf\"/>"
      "</TestRoot>"
    };
    MiX::DOM_Parser<char> parser;
    MiX::Document<char>* doc = parser.parse(data);
    try {
      doc->getRoot()("TestElement").queryNSName("url_for_hoge");
      CPPUNIT_FAIL("never reached here");
    }catch( MiX::DOM_Exception<char>& e ){
      CPPUNIT_ASSERT_EQUAL( MiX::NamespaceNotDefined ,e.getType() );
    }
    delete doc;
  }

  void test784() {
    const char data[] = {
      "<?xml?>\r\n"
      "<TestRoot xmlns=\"url_default\" xmlns:html=\"url_for_html\">\r\n"
      "<TestElement xmlns:rdf=\"url_for_rdf\"/>\r\n"
      "</TestRoot>\r\n"
    };
    MiX::DOM_Parser<char> parser;
    parser.setIgnoreSpace(true);
    MiX::Document<char>* doc = parser.parse(data);
    CPPUNIT_ASSERT( doc->getRoot().getText().empty() );
    delete doc;
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(KnownBugTest);
