from Products.CMFCore.utils import getToolByName
from Products.CMFFormController.FormAction import FormActionKey
from Products.Archetypes.Extensions.utils import installTypes
from Products.Archetypes.Extensions.utils import install_subskin
from Products.Archetypes.public import listTypes

from StringIO import StringIO

from Products.CMFDynamicViewFTI.migrate import migrateFTIs

from Products.PGraphviz.config import *

def install(self):
    """Install PGraphviz: Install content types, skin layer, install the
    stylesheet, set up global properties, enable the portal factory
    """

    out = StringIO()

    print >> out, "Installing PGraphviz"

    # Install types
    classes = listTypes(PROJECTNAME)
    installTypes(self, out,
                 classes,
                 PROJECTNAME)
    print >> out, "Installed types"

    # Install skin
    install_subskin(self, out, product_globals)
    print >> out, "Installed skin"

    # Migrate FTI, to make sure we get the necessary infrastructure for the
    # 'display' menu to work.
    migrated = migrateFTIs(self, product=PROJECTNAME)
    print >>out, "Switched to DynamicViewFTI: %s" % ', '.join(migrated)

    # Install stylesheet
    portal_css = getToolByName(self, 'portal_css')
    portal_css.manage_addStylesheet(id = 'pgraphviz.css',
                                    expression = 'python:object.getTypeInfo().getId() == "PGraphviz"',
                                    media = 'all',
                                    title = 'PGraphviz styles',
                                    enabled = True)

    # Enable portal_factory
    factory = getToolByName(self, 'portal_factory')
    types = factory.getFactoryTypes().keys()
    if 'PGraphviz' not in types:
        types.append('PGraphviz')
        factory.manage_setPortalFactoryTypes(listOfTypeIds = types)

    print >> out, "Added PGraphviz to portal_factory"

    propsTool = getToolByName(self, 'portal_properties')
    siteProperties = getattr(propsTool, 'site_properties')
    navtreeProperties = getattr(propsTool, 'navtree_properties')

    # Add to default_page_types
    defaultPageTypes = list(siteProperties.getProperty('default_page_types'))
    if 'PGraphviz' not in defaultPageTypes:
        defaultPageTypes.append('PGraphviz')
    siteProperties.manage_changeProperties(default_page_types = defaultPageTypes)

    # Add to parentMetaTypesNotToQuery
    parentMetaTypesNotToQuery = list(navtreeProperties.getProperty('parentMetaTypesNotToQuery'))
    if 'PGraphviz' not in parentMetaTypesNotToQuery:
        parentMetaTypesNotToQuery.append('PGraphviz')
    navtreeProperties.manage_changeProperties(parentMetaTypesNotToQuery = parentMetaTypesNotToQuery)

    return out.getvalue()
