#pragma once

#undef _EXPORT_
#ifdef PIC_KERNEL_EXPORTS
#define _EXPORT_ __declspec(dllexport) 
#else
#define _EXPORT_ __declspec(dllimport) 
#endif

class CPLFileData;
class CPLMemoryData;

class _EXPORT_ CPLData
{
public:
	CPLData( const char * chObject );
	CPLData( const char * chObject, CPLFileData *);
	CPLData( const char * chObject, CPLMemoryData *);
	~CPLData(void);

	bool __fastcall is_file( );
	bool __fastcall is_memory( );
	bool __fastcall set_file( CPLFileData * );
	bool __fastcall set_memory( CPLMemoryData * );
	CPLFileData * __fastcall get_file( );
	CPLMemoryData * __fastcall get_memory( );
	void get_name( char *chName, const unsigned int nBufferLen );

	static const char *DEFAULT_OBJECT_NAME;

protected:
	CPLFileData *m_file;
	CPLMemoryData *m_memory;
	bool m_bAutoDelete;
	char m_chObjectName[256];
};
