#pragma once

class StreamWriter : public StreamBasic
{
public:
	StreamWriter( )
	{
	}

	virtual ~StreamWriter( )
	{
	}

	virtual bool open( char *strFileName, bool bNew, bool bTemp )
	{
		return StreamBasic::open( strFileName, GENERIC_WRITE, bNew, bTemp );
	}

	virtual bool close( )
	{
		bool bResult = true;
		if( m_hFile )
		{
			flush( );
			bResult = StreamBasic::close( );
		}
		return bResult;
	}
	
	virtual bool flush( )
	{
		if( m_hFile )
		{
			DWORD dwWrite = 0;
			::WriteFile( m_hFile, m_pBuffer, m_nPosition, &dwWrite, NULL );
			m_nPosition = 0;
			return true;
		}
		else
		{
			return false;
		}
	}
	
	virtual bool write( unsigned char *pBuffer, , unsigned int nPosition, unsigned int nSize )
	{
		if( pBuffer == NULL )
			return false;
		unsigned int nPosition = 0;
		while( nPosition < nSize )
		{
			if( nSize - nPosition < _BUFFER_SIZE_ - m_nPosition )
			{
				memcpy( m_pBuffer + m_nPosition, pBuffer + nPosition, nSize - nPosition );
				m_nPosition += nSize - nPosition ;
				nPosition += nSize - nPosition;
			}
			else
			{
				DWORD dwWrite = 0;
				memcpy( m_pBuffer + m_nPosition, pBuffer + nPosition, _BUFFER_SIZE_ - m_nPosition );
				nPosition += _BUFFER_SIZE_ - m_nPosition;
				::WriteFile( m_hFile, m_pBuffer, _BUFFER_SIZE_, &dwWrite, NULL );
				m_nPosition = 0;
			}
		}
		return true;
	}
};
