#pragma once

#undef _EXPORT_KERNEL_
#ifdef PIC_KERNEL_EXPORTS
#define _EXPORT_KERNEL_ __declspec(dllexport) 
#else
#define _EXPORT_KERNEL_ __declspec(dllimport) 
#endif

#undef _EXPORT_PICTURE_FILTER_
#ifdef _PLUGIN_PICTURE_FILTER_
#define _EXPORT_PICTURE_FILTER_ __declspec(dllexport) 
#else
#define _EXPORT_PICTURE_FILTER_ __declspec(dllimport) 
#endif

#include <windows.h>

class CPLImage;
class CPLData;
class CPLMemoryData;

typedef struct
{
	int nVersionMejor;
	int nVersionMinor;
	char chPluginName[256];
	char chPluginCopyright[256];
	bool bSupport8_8;
	bool bSupport8_24;
	bool bSupport24_8;
	bool bSupport24_24;
} PLUGIN_INFO;

// Kernel function
// allocate memory.
_EXPORT_KERNEL_ void *PL_Malloc( int nSize, bool bInitial );

// free memory
_EXPORT_KERNEL_ void PL_Free( void *pMem );

_EXPORT_KERNEL_ bool __stdcall read_image_file_helper( const char *plugin, char *input, CPLImage *readImage );
_EXPORT_KERNEL_ bool __stdcall attach_memory_image_helper( const char *plugin, void *header, void *bits, CPLImage *readImage );
_EXPORT_KERNEL_ bool __stdcall write_image_file_helper( const char *plugin, char *input, CPLImage *writeImage, char *parameter );

// import-export plugin
string __stdcall get_copyright_info( );
typedef string ( __stdcall *FP_GET_COPYRIGHT_INFO)( );

bool __stdcall get_supported_file_list( string &strType, string &strExt );
typedef bool ( __stdcall *FP_GET_SUPPORTED_FILE_LIST)( string &strType, string &strExt );

// import plugin
bool __stdcall read_image( char *strFile, CPLImage &hImageResult );
typedef bool ( __stdcall *FP_READ_IMAGE)( char *, CPLImage & );

bool __stdcall attach_memory_image( void *pHeader, void *pBits, CPLImage &hImageResult );
typedef bool ( __stdcall *FP_ATTACH_MEMORY_IMAGE)( void *, void *, CPLImage & );

bool __stdcall is_supported_image( CPLData *pData );
typedef bool ( __stdcall *FP_IS_SUPPORTED_IMAGE)( CPLData* );

bool __stdcall get_image_info( CPLData *pData, int &width, int &height, int &colordepth );
typedef bool ( __stdcall *FP_GET_IMAGE_INFO)( CPLData *, int &, int &, int & );

// export plugin
bool __stdcall write_image( CPLImage *pImage, char *strFile, char *parameter );
typedef bool ( __stdcall *FP_WRITE_IMAGE)( CPLImage *, char *, char * );

bool __stdcall make_memory_image( CPLImage &ImageSource, CPLMemoryData &headerTarget, CPLMemoryData &pixelTarget );
typedef bool ( __stdcall *FP_MAKE_MEMORY_IMAGE)( CPLImage &, CPLMemoryData &, CPLMemoryData & );

bool __stdcall make_memory_image_rect( CPLImage &ImageSource, int nTop, int nLeft, int nWidth, int nHeight, CPLMemoryData &headerTarget, CPLMemoryData &pixelTarget );
typedef bool ( __stdcall *FP_MAKE_MEMORY_IMAGE_RECT)( CPLImage &ImageSource, int nTop, int nLeft, int nWidth, int nHeight, CPLMemoryData &headerTarget, CPLMemoryData &pixelTarget );

// filter plugin
_EXPORT_PICTURE_FILTER_ bool __stdcall GetPluginInfo ( PLUGIN_INFO *pInfo );
typedef bool ( __stdcall *FP_GET_PLUGIN_INFO)( PLUGIN_INFO *pInfo );

_EXPORT_PICTURE_FILTER_ bool __stdcall do_filter( CPLImage *hImageIn, CPLImage *hImageOut, void *option );
typedef bool ( __stdcall *FP_DO_FILTER)( CPLImage*, CPLImage*, void * );

_EXPORT_PICTURE_FILTER_ int __stdcall GetOptionSize( );
typedef int ( __stdcall *FP_GET_OPTION_SIZE )(  );

_EXPORT_PICTURE_FILTER_ bool __stdcall GetDefaultOption( void *pDefaultOption );
typedef bool ( __stdcall *FP_GET_DEFAULT_OPTION )( void * );

_EXPORT_PICTURE_FILTER_ bool __stdcall Configure( HWND hWndParent, LPVOID pOption );
typedef bool ( __stdcall *FP_CONFIGURE )( HWND, LPVOID );

