#pragma once

#include <windows.h>
#include "../hed/hed_susie/susie.h"

#undef _EXPORT_
#ifdef SPLG_PICTURE_EXPORTS
#define _EXPORT_ __declspec(dllexport) 
#else
#define _EXPORT_ __declspec(dllimport) 
#endif

class CPLData;

typedef int (PASCAL *CALLBACKPROGRESS_SUSIE)(int,int,long);

class _EXPORT_ CPluginObject
{
public:
	CPluginObject(void);
	virtual ~CPluginObject(void);

	static CPluginObject *CreateObject(const char* const strFileName);
	static void DestroyObject( CPluginObject *pObject );
	static int GetPluginType( const char* const strPluginName);

	virtual bool IsSupported( CPLData *pData );
	virtual string GetCopyright( );
	virtual bool GetExtSetting( int nIndex, string &strType, string &strExt );
	virtual string GenFileTypeString( );
protected:
	char				m_PluginName[MAX_PATH];
	char				m_PluginCopyright[256];
	FILE_TYPE_LIST		*m_SupportedFile;

	HINSTANCE			m_hInstance;
	GETPLUGININFO		m_fpGetPluginInfo;
	GETPICTUREINFO		m_fpGetPictureInfo;
	ISSUPPORTED			m_fpIsSupported;
	GETPICTURE			m_fpGetPicture;
	GETPREVIEW			m_fpGetPreview;
	GETARCHIVEINFO		m_fpGetArchiveInfo;
	GETFILE				m_fpGetFile;
	CONFIGURATIONDLG	m_fpConfigrationDlg;
	virtual bool Create( const char * const strPluginName );
	virtual bool LoadPluginObject( );
	virtual void UnloadPluginObject( );
	virtual bool Initialize( const char * const strPluginName );
	virtual bool TestPlugin( ) = 0;
	virtual bool CreateFileTypeList( );

	static int PASCAL SusieDefaultCallBack(int nNum, int nDenom, long lData);
};
