#pragma once

#define ERROR_SUSIE_WIN32_EXCEPTION 0x80000000;
#define ERROR_SUSIE_PARAM_NOT_CORRECT 0x80000001;
#define ERROR_SUSIE_NOT_FUNCTION_POINTER 0x80000002;
#pragma once

#include<windows.h>
#include <time.h>

#include <pshpack1.h>
struct PictureInfo
{
	DWORD left,top;		//摜WJʒu
	DWORD width;		//摜̕(pixel)
	DWORD height;		//摜̍(pixel)
	WORD x_density;		//f̐x
	WORD y_density;		//f̐x
	WORD colorDepth;	//Pfbit
	HLOCAL hInfo;		//摜̃eLXg
};
#include <poppack.h>

typedef struct
{
	BYTE method[8];     //k@̎
	DWORD position;     //t@Cł̈ʒu
	DWORD compsize;     //kꂽTCY
	DWORD filesize;     //̃t@CTCY
	time_t timestamp;   //t@C̍XV
	char path[200];     //΃pX
	char filename[200]; //t@Cl[
	DWORD crc;          //CRC
} fileInfo;

typedef int (CALLBACK *GETPLUGININFO)(int,LPSTR,int);
typedef int (CALLBACK *GETPICTUREINFO)(void*,long,unsigned int,PictureInfo *);
typedef int (CALLBACK *ISSUPPORTED)(LPSTR,void*);
typedef int (CALLBACK *GETPICTURE)(void*,long,unsigned int,HANDLE,HANDLE,FARPROC,long);
typedef int (CALLBACK *GETPREVIEW)(void*,long,unsigned int,HANDLE,HANDLE,FARPROC,long);
typedef int (CALLBACK *GETARCHIVEINFO)(void*, long, DWORD, HLOCAL *);
typedef int (CALLBACK *GETFILEINFO)(void*, long, LPSTR, DWORD, fileInfo *);
typedef int (CALLBACK *GETFILE)(LPSTR, long, LPSTR, unsigned int, FARPROC, long);
typedef int (CALLBACK *CONFIGURATIONDLG)(HWND hWnd, int fnc);

extern "C" int __stdcall GetPluginInfo(GETPLUGININFO fp, int infNo, LPSTR buf, int nBufLen);
extern "C" int __stdcall GetPictureInfo(GETPICTUREINFO fp, void* buf, long lBufLen, unsigned int flag, PictureInfo *lpInfo);
extern "C" int __stdcall IsSupported(ISSUPPORTED fp, LPSTR lpFileName, void *pMem);
extern "C" int __stdcall GetPicture(GETPICTURE fp, LPSTR src, long len, unsigned int flag, HANDLE *pHBInfo,HANDLE *pHBm, FARPROC lpPrgressCallback,long lData);
extern "C" int __stdcall GetPreview(GETPREVIEW fp, LPSTR src, long len, unsigned int flag, HANDLE *pHBInfo,HANDLE *pHBm, FARPROC lpProgressCallback,long lData);
extern "C" int __stdcall GetArchiveInfo(GETARCHIVEINFO fp, LPSTR src, long lBufLen, unsigned int flag, HLOCAL *lpInfo);
extern "C" int __stdcall GetFileInfo(GETFILEINFO fp, LPSTR src, long lOffSet, LPSTR lpFileName, DWORD flag, fileInfo *lpFileInfo);
extern "C" int __stdcall GetFile(GETFILE fp, LPSTR src,long len, LPSTR dest,unsigned int flag, FARPROC progressCallback,long lData);
extern "C" int __stdcall ConfigurationDlg(CONFIGURATIONDLG fp, HWND parent, int fnc);


typedef struct tagFILE_TYPE_LIST
{
	vector<string> Exp;
	char FileTypeName[256];
	tagFILE_TYPE_LIST *pNext;
} FILE_TYPE_LIST;

typedef struct
{
	enum PLUGIN_TYPE
	{
		E_SUSIE_PICTURE,
		E_SUSIE_ARCHIVE,
	};
	PLUGIN_TYPE PluginType;
	char PluginName[MAX_PATH];
	char PluginCopyright[256];
	FILE_TYPE_LIST *SupportedFile;

	HINSTANCE hInstance;
	BOOL			bLoaded;
	GETPLUGININFO	fpGetPluginInfo;
	GETPICTUREINFO	fpGetPictureInfo;
	ISSUPPORTED		fpIsSupported;
	GETPICTURE		fpGetPicture;
	GETPREVIEW		fpGetPreview;
	GETARCHIVEINFO	fpGetArchiveInfo;
	GETFILE			fpGetFile;
	CONFIGURATIONDLG	fpConfigrationDlg;
} PluginInformation;

// Plugingq
static const char SUSIE_PLUGIN_EXT[] = ".SPI";
static const char PICTURE_EXPORT_PLUGIN_EXT[] = ".EPLG";
static const char PICTURE_IMPORT_PLUGIN_EXT[] = ".IPLG";
static const char PICTURE_FILTER_PLUGIN_EXT[] = ".FPLG";

