// FastStream.cpp: CFastStream NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "../hed/hed_common/stl.h"
#include "../hed/hed_picturelib/faststream.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

const UINT CFastStream::OPEN_READ = 1;
const UINT CFastStream::OPEN_WRITE = 2;
const UINT CFastStream::OPEN_TRUNC = 4;
const UINT CFastStream::OPEN_TEMP = 8;

CFastStream::CFastStream()
{
	init();

	_BUFFER_SIZE_ = 64 * 1024;
	m_buffer = (unsigned char*)malloc( _BUFFER_SIZE_ );
}

CFastStream::~CFastStream()
{
	if( m_hFile )
		::CloseHandle( m_hFile );
	free( m_buffer );
	free( m_pTempBuffer );
}

void CFastStream::init( )
{
	m_TempBufferSize = 0;
	m_pTempBuffer = NULL;
	m_bTempFile = FALSE;
	m_hFile = NULL;
	m_sizeofUsedBuffer = 0;
	m_bWrite = FALSE;
	m_currentBufferStartPosition = -1;
	m_uiMode = 0;
	memset( m_strFileName, 0x00, MAX_PATH );
}

bool CFastStream::open( char *strFileName, UINT uiOpenMode )
{
	if( !strFileName || m_hFile )
		return false;

	DWORD dwOpenMode = 0;
	if( uiOpenMode & OPEN_READ )
		dwOpenMode = dwOpenMode |= GENERIC_READ;
	if( uiOpenMode & OPEN_WRITE )
		dwOpenMode |= GENERIC_WRITE | GENERIC_READ;
	if( uiOpenMode & OPEN_TRUNC )
		::DeleteFile( strFileName );
	if( uiOpenMode & OPEN_TEMP )
		m_bTempFile = true;
	else
		m_bTempFile = false;

	if( !uiOpenMode )
		return false;
	m_hFile = ::CreateFile( strFileName, dwOpenMode, 0, NULL, OPEN_ALWAYS, 0, 0 );
	if( m_hFile != INVALID_HANDLE_VALUE )
	{
		strncpy( m_strFileName, strFileName, MAX_PATH );
		return true;
	}
	else
	{
		m_hFile = NULL;
		return false;
	}
}

bool CFastStream::read( unsigned char *pBuffer, unsigned int nPosition, unsigned int nSize )
{
	if( !pBuffer || nSize <= 0 )
		return false;

	bool bResult = false;
	DWORD NumberOfBytesRead = 0;
	SetLastError( 0 );
	if( nPosition / _BUFFER_SIZE_ == ( ( int )( nPosition + nSize - 1 ) ) / _BUFFER_SIZE_ )
	{
		if( m_currentBufferStartPosition != ( ( int ) (nPosition / _BUFFER_SIZE_) ) * _BUFFER_SIZE_ )
		{
			flush( );
			DWORD dwError = ::SetFilePointer( m_hFile,
				nPosition / _BUFFER_SIZE_ * _BUFFER_SIZE_,
				NULL,
				FILE_BEGIN );
			if( dwError != INVALID_SET_FILE_POINTER &&
				dwError == nPosition / _BUFFER_SIZE_ * _BUFFER_SIZE_ &&
				GetLastError() == NOERROR )
			{
				dwError = ::ReadFile( m_hFile,
					m_buffer,
					_BUFFER_SIZE_,
					&NumberOfBytesRead,
					NULL );
				if( dwError == 0 )
				{
					m_currentBufferStartPosition = -1;
					m_sizeofUsedBuffer = 0;
				}
				else
				{
					m_currentBufferStartPosition = (nPosition / _BUFFER_SIZE_) * _BUFFER_SIZE_;
					m_sizeofUsedBuffer = NumberOfBytesRead;
				}
			}
		}
		if( m_sizeofUsedBuffer >= nPosition % _BUFFER_SIZE_ + nSize )
		{
			memcpy( pBuffer, &m_buffer[nPosition % _BUFFER_SIZE_], nSize );
			bResult = true;
		}
	}
	else
	{
		flush( );
		DWORD dwError = ::SetFilePointer( m_hFile,
			nPosition,
			NULL,
			FILE_BEGIN );
		if( dwError != INVALID_SET_FILE_POINTER &&
			dwError == nPosition &&
			GetLastError() == NOERROR )
		{
			dwError = ::ReadFile( m_hFile,
				pBuffer,
				nSize,
				&NumberOfBytesRead,
				NULL );
			if( dwError != 0 &&
				NumberOfBytesRead == nSize )
			{
				bResult = true;
			}
		}
	}
	return bResult;
}

bool __fastcall CFastStream::direct_read( const unsigned char ** const pBuffer, unsigned int nPosition, unsigned int nSize )
{
	if( !pBuffer || nSize <= 0 )
		return false;

	*pBuffer = NULL;
	bool bResult = false;
	DWORD NumberOfBytesRead = 0;

	if( nPosition / _BUFFER_SIZE_ == ( ( int )( nPosition + nSize - 1 ) ) / _BUFFER_SIZE_ )
	{
		if( m_currentBufferStartPosition != ( ( int ) (nPosition / _BUFFER_SIZE_) ) * _BUFFER_SIZE_ )
		{
			flush( );
			SetLastError( NOERROR );
			DWORD dwError = ::SetFilePointer( m_hFile,
				( (int)(nPosition / _BUFFER_SIZE_) ) * _BUFFER_SIZE_,
				NULL,
				FILE_BEGIN );
			if( dwError != INVALID_SET_FILE_POINTER &&
				dwError == ( ( int ) (nPosition / _BUFFER_SIZE_) ) * _BUFFER_SIZE_ &&
				GetLastError() == NOERROR )
			{
				dwError = ::ReadFile( m_hFile,
					m_buffer,
					_BUFFER_SIZE_,
					&NumberOfBytesRead,
					NULL );
				if( dwError == 0 )
				{
					m_currentBufferStartPosition = -1;
					m_sizeofUsedBuffer = 0;
				}
				else
				{
					m_currentBufferStartPosition = (nPosition / _BUFFER_SIZE_) * _BUFFER_SIZE_;
					m_sizeofUsedBuffer = NumberOfBytesRead;
					bResult = true;
				}
			}
		}
		if( m_sizeofUsedBuffer >= nPosition % _BUFFER_SIZE_ + nSize )
		{
			*pBuffer = m_buffer + nPosition % _BUFFER_SIZE_ ;
			bResult = true;
		}
	}
	else
	{
		flush( );
		if( m_TempBufferSize < (unsigned int)nSize )
		{
			free( m_pTempBuffer );
			m_pTempBuffer = (unsigned char*)malloc( nSize );
			m_TempBufferSize = nSize;
		}
		else if( m_TempBufferSize > (unsigned int)nSize * 2 )
		{
			free( m_pTempBuffer );
			m_pTempBuffer = (unsigned char*)malloc( nSize );
			m_TempBufferSize = nSize;
		}
		SetLastError( NOERROR );
		DWORD dwError = ::SetFilePointer( m_hFile,
			nPosition,
			NULL,
			FILE_BEGIN );
		if( dwError != INVALID_SET_FILE_POINTER &&
			dwError == nPosition &&
			GetLastError() == NOERROR )
		{
			dwError = ::ReadFile( m_hFile,
				m_pTempBuffer,
				nSize,
				&NumberOfBytesRead,
				NULL );
			if( dwError != 0 &&
				NumberOfBytesRead == nSize )
			{
				*pBuffer = m_pTempBuffer;
				bResult = true;
			}
		}
	}
	return bResult;
}

bool CFastStream::write( unsigned char *pBuffer, unsigned int nPosition, unsigned int nSize )
{
	bool bResult = false;
	if( !pBuffer || nSize <= 0)
		return false;

	DWORD NumberOfBytesRead = 0, NumberOfBytesWrite = 0;
	SetLastError(0);
	if( nPosition / _BUFFER_SIZE_ == ( nPosition + nSize - 1 ) / _BUFFER_SIZE_ )
	{
		if( m_currentBufferStartPosition != (nPosition / _BUFFER_SIZE_) * _BUFFER_SIZE_ )
		{
			flush( );
			DWORD dwError = ::SetFilePointer( m_hFile,
				(nPosition / _BUFFER_SIZE_) * _BUFFER_SIZE_,
				NULL,
				FILE_BEGIN );
			if( dwError != INVALID_SET_FILE_POINTER &&
				dwError == ( ( int ) (nPosition / _BUFFER_SIZE_) ) * _BUFFER_SIZE_ &&
				GetLastError() == NOERROR )
			{
				dwError = ::ReadFile( m_hFile,
					m_buffer,
					_BUFFER_SIZE_,
					&NumberOfBytesRead,
					NULL );
				if( dwError == 0 )
				{
					m_currentBufferStartPosition = -1;
					m_sizeofUsedBuffer = 0;
				}
				else
				{
					m_currentBufferStartPosition = (nPosition / _BUFFER_SIZE_) * _BUFFER_SIZE_;
					m_sizeofUsedBuffer = NumberOfBytesRead;
				}
			}
		}
		if( m_currentBufferStartPosition >= 0 )
		{
			memcpy( &m_buffer[nPosition % _BUFFER_SIZE_], pBuffer, nSize );
			bResult = true;
			if( m_sizeofUsedBuffer < nPosition % _BUFFER_SIZE_ + nSize )
			{
				m_sizeofUsedBuffer = nPosition % _BUFFER_SIZE_ + nSize;
			}
		}
	}
	else
	{
		flush();
		DWORD dwError = ::SetFilePointer( m_hFile,
			nPosition,
			NULL,
			FILE_BEGIN );
		if( dwError != INVALID_SET_FILE_POINTER &&
			dwError == nPosition &&
			GetLastError() == NOERROR )
		{
			DWORD dwError = ::WriteFile( m_hFile,
				pBuffer,
				nSize,
				&NumberOfBytesWrite,
				NULL );
			if( dwError != 0 &&
				NumberOfBytesWrite == nSize )
			{
				bResult = true;
			}
			m_currentBufferStartPosition = -1;
			m_sizeofUsedBuffer = 0;
		}
	}
	if( bResult )
		m_bWrite = TRUE;
	return bResult;
}

bool CFastStream::flush( )
{
	if( !m_hFile || !m_bWrite )
		return false;
	DWORD NumberOfBytesWrite = 0;
	SetLastError( 0 );

	bool bResult = false;
	DWORD dwError = ::SetFilePointer( m_hFile,
		m_currentBufferStartPosition,
		NULL,
		FILE_BEGIN );
	if( dwError != INVALID_SET_FILE_POINTER &&
		dwError == m_currentBufferStartPosition &&
		GetLastError() == NOERROR )
	{
		::WriteFile( m_hFile,
			m_buffer,
			m_sizeofUsedBuffer,
			&NumberOfBytesWrite,
			NULL );
		bResult = true;
	}
	SetLastError( 0 );
	m_bWrite = false;
	return bResult;
}

bool CFastStream::close( )
{
	if( m_hFile )
	{
		flush( );
		::CloseHandle( m_hFile );
		if( m_bTempFile )
			::DeleteFile( m_strFileName );
		init( );
		return true;
	}
	else
	{
		return false;
	}
}

bool CFastStream::is_open( )
{
	return (m_hFile != NULL);
}

void CFastStream::get_file_name( char *strFileName )
{
	if( strFileName )
	{
		strncpy( strFileName, m_strFileName, MAX_PATH );
	}
}